/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.SlackConfiguration;
import java.util.List;

@SdkInternalApi
public class SlackConfigurationMarshaller {
    private static final MarshallingInfo<String> TEAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TeamId").build();
    private static final MarshallingInfo<String> SECRETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretArn").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfiguration").build();
    private static final MarshallingInfo<List> SLACKENTITYLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SlackEntityList").build();
    private static final MarshallingInfo<Boolean> USECHANGELOG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseChangeLog").build();
    private static final MarshallingInfo<Boolean> CRAWLBOTMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrawlBotMessage").build();
    private static final MarshallingInfo<Boolean> EXCLUDEARCHIVED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExcludeArchived").build();
    private static final MarshallingInfo<String> SINCECRAWLDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SinceCrawlDate").build();
    private static final MarshallingInfo<Integer> LOOKBACKPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LookBackPeriod").build();
    private static final MarshallingInfo<List> PRIVATECHANNELFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateChannelFilter").build();
    private static final MarshallingInfo<List> PUBLICCHANNELFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicChannelFilter").build();
    private static final MarshallingInfo<List> INCLUSIONPATTERNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InclusionPatterns").build();
    private static final MarshallingInfo<List> EXCLUSIONPATTERNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusionPatterns").build();
    private static final MarshallingInfo<List> FIELDMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FieldMappings").build();
    private static final SlackConfigurationMarshaller instance = new SlackConfigurationMarshaller();

    public static SlackConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SlackConfiguration slackConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (slackConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)slackConfiguration.getTeamId(), TEAMID_BINDING);
            protocolMarshaller.marshall((Object)slackConfiguration.getSecretArn(), SECRETARN_BINDING);
            protocolMarshaller.marshall((Object)slackConfiguration.getVpcConfiguration(), VPCCONFIGURATION_BINDING);
            protocolMarshaller.marshall(slackConfiguration.getSlackEntityList(), SLACKENTITYLIST_BINDING);
            protocolMarshaller.marshall((Object)slackConfiguration.getUseChangeLog(), USECHANGELOG_BINDING);
            protocolMarshaller.marshall((Object)slackConfiguration.getCrawlBotMessage(), CRAWLBOTMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)slackConfiguration.getExcludeArchived(), EXCLUDEARCHIVED_BINDING);
            protocolMarshaller.marshall((Object)slackConfiguration.getSinceCrawlDate(), SINCECRAWLDATE_BINDING);
            protocolMarshaller.marshall((Object)slackConfiguration.getLookBackPeriod(), LOOKBACKPERIOD_BINDING);
            protocolMarshaller.marshall(slackConfiguration.getPrivateChannelFilter(), PRIVATECHANNELFILTER_BINDING);
            protocolMarshaller.marshall(slackConfiguration.getPublicChannelFilter(), PUBLICCHANNELFILTER_BINDING);
            protocolMarshaller.marshall(slackConfiguration.getInclusionPatterns(), INCLUSIONPATTERNS_BINDING);
            protocolMarshaller.marshall(slackConfiguration.getExclusionPatterns(), EXCLUSIONPATTERNS_BINDING);
            protocolMarshaller.marshall(slackConfiguration.getFieldMappings(), FIELDMAPPINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

