/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollectorManager;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.TotalHitCountCollectorManager;
import org.apache.lucene.search.TotalHits;

public class FacetsCollectorManager
implements CollectorManager<FacetsCollector, FacetsCollector> {
    private final boolean keepScores;

    public FacetsCollectorManager() {
        this(false);
    }

    public FacetsCollectorManager(boolean keepScores) {
        this.keepScores = keepScores;
    }

    public FacetsCollector newCollector() throws IOException {
        return new FacetsCollector(this.keepScores);
    }

    public FacetsCollector reduce(Collection<FacetsCollector> collectors) throws IOException {
        if (collectors == null || collectors.size() == 0) {
            return new FacetsCollector();
        }
        if (collectors.size() == 1) {
            return collectors.iterator().next();
        }
        assert (collectors.stream().allMatch(fc -> fc.getKeepScores() == this.keepScores));
        return new ReducedFacetsCollector(collectors, this.keepScores);
    }

    public static FacetsResult search(IndexSearcher searcher, Query q, int n, FacetsCollectorManager fcm) throws IOException {
        return FacetsCollectorManager.doSearch(searcher, null, q, n, null, false, fcm);
    }

    public static FacetsResult search(IndexSearcher searcher, Query q, int n, Sort sort, FacetsCollectorManager fcm) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollectorManager.doSearch(searcher, null, q, n, sort, false, fcm);
    }

    public static FacetsResult search(IndexSearcher searcher, Query q, int n, Sort sort, boolean doDocScores, FacetsCollectorManager fcm) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollectorManager.doSearch(searcher, null, q, n, sort, doDocScores, fcm);
    }

    public static FacetsResult searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, FacetsCollectorManager fcm) throws IOException {
        return FacetsCollectorManager.doSearch(searcher, after, q, n, null, false, fcm);
    }

    public static FacetsResult searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, FacetsCollectorManager fcm) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollectorManager.doSearch(searcher, after, q, n, sort, false, fcm);
    }

    public static FacetsResult searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, boolean doDocScores, FacetsCollectorManager fcm) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollectorManager.doSearch(searcher, after, q, n, sort, doDocScores, fcm);
    }

    private static FacetsResult doSearch(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, boolean doDocScores, FacetsCollectorManager fcm) throws IOException {
        FacetsCollector facetsCollector;
        TopDocs topDocs;
        int limit = searcher.getIndexReader().maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        n = Math.min(n, limit);
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        if (n == 0) {
            TotalHitCountCollectorManager hitCountCollectorManager = new TotalHitCountCollectorManager();
            MultiCollectorManager multiCollectorManager = new MultiCollectorManager(new CollectorManager[]{hitCountCollectorManager, fcm});
            Object[] result = (Object[])searcher.search(q, (CollectorManager)multiCollectorManager);
            topDocs = new TopDocs(new TotalHits((long)((Integer)result[0]).intValue(), TotalHits.Relation.EQUAL_TO), new ScoreDoc[0]);
            facetsCollector = (FacetsCollector)((Object)result[1]);
        } else {
            MultiCollectorManager multiCollectorManager;
            if (sort != null) {
                if (after != null && !(after instanceof FieldDoc)) {
                    throw new IllegalArgumentException("after must be a FieldDoc; got " + after);
                }
                TopFieldCollectorManager topFieldCollectorManager = new TopFieldCollectorManager(sort, n, (FieldDoc)after, Integer.MAX_VALUE, true);
                multiCollectorManager = new MultiCollectorManager(new CollectorManager[]{topFieldCollectorManager, fcm});
            } else {
                TopScoreDocCollectorManager topScoreDocCollectorManager = new TopScoreDocCollectorManager(n, after, Integer.MAX_VALUE, true);
                multiCollectorManager = new MultiCollectorManager(new CollectorManager[]{topScoreDocCollectorManager, fcm});
            }
            Object[] result = (Object[])searcher.search(q, (CollectorManager)multiCollectorManager);
            topDocs = (TopDocs)result[0];
            if (doDocScores) {
                TopFieldCollector.populateScores((ScoreDoc[])topDocs.scoreDocs, (IndexSearcher)searcher, (Query)q);
            }
            facetsCollector = (FacetsCollector)((Object)result[1]);
        }
        return new FacetsResult(topDocs, facetsCollector);
    }

    public static class FacetsResult {
        private final TopDocs topDocs;
        private final FacetsCollector facetsCollector;

        public FacetsResult(TopDocs topDocs, FacetsCollector facetsCollector) {
            this.topDocs = topDocs;
            this.facetsCollector = facetsCollector;
        }

        public TopDocs topDocs() {
            return this.topDocs;
        }

        public FacetsCollector facetsCollector() {
            return this.facetsCollector;
        }
    }

    private static class ReducedFacetsCollector
    extends FacetsCollector {
        ReducedFacetsCollector(Collection<FacetsCollector> facetsCollectors, boolean keepScores) {
            super(keepScores);
            List<FacetsCollector.MatchingDocs> matchingDocs = this.getMatchingDocs();
            facetsCollectors.forEach(facetsCollector -> matchingDocs.addAll(facetsCollector.getMatchingDocs()));
        }
    }
}

