/*
 * Decompiled with CFR 0.152.
 */
package com.example.providers;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.providers.WikiPageProvider;
import org.apache.wiki.search.QueryItem;
import org.apache.wiki.search.SearchMatcher;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.search.SearchResultComparator;

public class TwoXWikiPageProvider
implements WikiPageProvider {
    WikiEngine engine;
    Map<String, List<WikiPage>> pages = new ConcurrentHashMap<String, List<WikiPage>>();
    Map<String, List<String>> contents = new ConcurrentHashMap<String, List<String>>();

    public String getProviderInfo() {
        return this.getClass().getName();
    }

    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        this.engine = engine;
        try {
            this.putPageText(new WikiPage(engine, "page1"), "blablablabla");
            this.putPageText(new WikiPage(engine, "page2"), "bleblebleble");
            this.putPageText(new WikiPage(engine, "page3"), "blibliblibli");
        }
        catch (ProviderException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void putPageText(WikiPage page, String text) throws ProviderException {
        page.setVersion(page.getVersion() + 1);
        page.setLastModified(new Date());
        if (this.pageExists(page.getName())) {
            this.pages.get(page.getName()).add(page);
            this.contents.get(page.getName()).add(text);
        } else {
            this.pages.put(page.getName(), new ArrayList<WikiPage>(Arrays.asList(page)));
            this.contents.put(page.getName(), new ArrayList<String>(Arrays.asList(text)));
        }
    }

    public boolean pageExists(String page) {
        return this.pages.get(page) != null && this.contents.get(page) != null;
    }

    <S> S executeIfPageExists(String page, int version, Supplier<S> s) throws ProviderException {
        if (this.pageExists(page, version)) {
            try {
                return s.get();
            }
            catch (Exception e) {
                throw new ProviderException(e.getMessage());
            }
        }
        return null;
    }

    public boolean pageExists(String page, int version) {
        return this.pages.get(page) != null && this.pages.get(page).size() >= version && this.contents.get(page) != null && this.contents.get(page).size() >= version;
    }

    public Collection<SearchResult> findPages(QueryItem[] query) {
        TreeSet<SearchResult> res = new TreeSet<SearchResult>((Comparator<SearchResult>)new SearchResultComparator());
        SearchMatcher matcher = new SearchMatcher(this.engine, query);
        Map<String, WikiPage> wikipages = this.pages.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, WikiPage>((String)e.getKey(), (WikiPage)((List)e.getValue()).get(((List)e.getValue()).size() - 1))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        for (String wikipage : wikipages.keySet()) {
            String pagetext = this.contents.get(wikipage).get(this.contents.get(wikipage).size() - 1);
            try {
                SearchResult comparison = matcher.matchPageContent(wikipage, pagetext);
                if (comparison == null) continue;
                res.add(comparison);
            }
            catch (IOException iOException) {}
        }
        return res;
    }

    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        return this.executeIfPageExists(page, version, () -> this.pages.get(page).get(version));
    }

    public Collection<WikiPage> getAllPages() throws ProviderException {
        return this.pages.values().stream().map(versions -> (WikiPage)versions.get(versions.size() - 1)).collect(Collectors.toList());
    }

    public Collection<WikiPage> getAllChangedSince(Date date) {
        try {
            return this.getAllPages();
        }
        catch (ProviderException e) {
            return Collections.emptyList();
        }
    }

    public int getPageCount() throws ProviderException {
        return this.pages.size();
    }

    public List<WikiPage> getVersionHistory(String page) throws ProviderException {
        return this.pageExists(page) ? this.pages.get(page) : Collections.emptyList();
    }

    public String getPageText(String page, int version) throws ProviderException {
        return this.executeIfPageExists(page, version, () -> {
            int v = version == -1 ? this.contents.get(page).size() - 1 : version;
            return this.contents.get(page).get(v);
        });
    }

    public void deleteVersion(String pageName, int version) throws ProviderException {
        this.executeIfPageExists(pageName, version, () -> {
            this.pages.get(pageName).remove(version);
            this.contents.get(pageName).remove(version);
            return null;
        });
    }

    public void deletePage(String pageName) throws ProviderException {
        this.pages.remove(pageName);
        this.contents.remove(pageName);
    }

    public void movePage(String from, String to) throws ProviderException {
        if (this.pageExists(to)) {
            throw new ProviderException(to + " page already exists, can't move there");
        }
        this.pages.put(to, this.pages.get(from));
        this.contents.put(to, this.contents.get(from));
        this.pages.remove(from);
        this.contents.remove(from);
    }
}

