/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.user;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.user.DefaultUserProfile;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.util.ByteUtils;
import org.apache.wiki.util.CryptoUtil;

public abstract class AbstractUserDatabase
implements UserDatabase {
    protected static final Logger LOG = LogManager.getLogger(AbstractUserDatabase.class);
    protected static final String SHA_PREFIX = "{SHA}";
    protected static final String SSHA_PREFIX = "{SSHA}";
    protected static final String SHA256_PREFIX = "{SHA-256}";

    @Override
    public UserProfile find(String index) throws NoSuchPrincipalException {
        UserProfile profile = null;
        try {
            profile = this.findByFullName(index);
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        if (profile != null) {
            return profile;
        }
        try {
            profile = this.findByWikiName(index);
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        if (profile != null) {
            return profile;
        }
        try {
            profile = this.findByLoginName(index);
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        if (profile != null) {
            return profile;
        }
        throw new NoSuchPrincipalException("Not in database: " + index);
    }

    @Override
    public abstract UserProfile findByEmail(String var1) throws NoSuchPrincipalException;

    @Override
    public abstract UserProfile findByFullName(String var1) throws NoSuchPrincipalException;

    @Override
    public abstract UserProfile findByLoginName(String var1) throws NoSuchPrincipalException;

    @Override
    public abstract UserProfile findByWikiName(String var1) throws NoSuchPrincipalException;

    @Override
    public Principal[] getPrincipals(String identifier) throws NoSuchPrincipalException {
        UserProfile profile = this.findByLoginName(identifier);
        ArrayList<WikiPrincipal> principals = new ArrayList<WikiPrincipal>();
        if (profile.getLoginName() != null && !profile.getLoginName().isEmpty()) {
            principals.add(new WikiPrincipal(profile.getLoginName(), "loginName"));
        }
        if (profile.getFullname() != null && !profile.getFullname().isEmpty()) {
            principals.add(new WikiPrincipal(profile.getFullname(), "fullName"));
        }
        if (profile.getWikiName() != null && !profile.getWikiName().isEmpty()) {
            principals.add(new WikiPrincipal(profile.getWikiName(), "wikiName"));
        }
        return principals.toArray(new Principal[0]);
    }

    @Override
    public abstract void initialize(Engine var1, Properties var2) throws NoRequiredPropertyException, WikiSecurityException;

    @Override
    public UserProfile newProfile() {
        DefaultUserProfile profile = new DefaultUserProfile();
        profile.setUid(AbstractUserDatabase.generateUid(this));
        return profile;
    }

    @Override
    public abstract void save(UserProfile var1) throws WikiSecurityException;

    @Override
    public boolean validatePassword(String loginName, String password) {
        try {
            UserProfile profile = this.findByLoginName(loginName);
            String storedPassword = profile.getPassword();
            boolean verified = false;
            if (storedPassword.startsWith(SHA256_PREFIX) || storedPassword.startsWith(SSHA_PREFIX)) {
                verified = CryptoUtil.verifySaltedPassword((byte[])password.getBytes(StandardCharsets.UTF_8), (String)storedPassword);
            }
            if (storedPassword.startsWith(SHA_PREFIX)) {
                storedPassword = storedPassword.substring(SHA_PREFIX.length());
                String hashedPassword = this.getShaHash(password);
                verified = hashedPassword.equals(storedPassword);
            }
            if (verified && !storedPassword.startsWith(SHA256_PREFIX)) {
                profile.setPassword(password);
                this.save(profile);
            }
            return verified;
        }
        catch (NoSuchPrincipalException profile) {
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Unsupported algorithm: " + e.getMessage());
        }
        catch (WikiSecurityException e) {
            LOG.error("Could not upgrade SHA password to SSHA because profile could not be saved. Reason: " + e.getMessage(), (Throwable)((Object)e));
        }
        return false;
    }

    protected static String generateUid(UserDatabase db) {
        String uid;
        boolean collision;
        do {
            uid = UUID.randomUUID().toString();
            collision = true;
            try {
                db.findByUid(uid);
            }
            catch (NoSuchPrincipalException e) {
                collision = false;
            }
        } while (collision || uid == null);
        return uid;
    }

    protected String getHash(String text) {
        try {
            return CryptoUtil.getSaltedPassword((byte[])text.getBytes(StandardCharsets.UTF_8), (String)SHA256_PREFIX);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Error creating salted password hash: {}", (Object)e.getMessage());
            return text;
        }
    }

    @Deprecated
    String getShaHash(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            byte[] digestedBytes = md.digest();
            return ByteUtils.bytes2hex((byte[])digestedBytes);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Error creating SHA password hash:" + e.getMessage());
            return text;
        }
    }

    protected long parseLong(String value) {
        if (NumberUtils.isParsable((String)value)) {
            return Long.parseLong(value);
        }
        return 0L;
    }
}

