/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.pages;

import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.WikiBackgroundThread;
import org.apache.wiki.api.core.Acl;
import org.apache.wiki.api.core.AclEntry;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.providers.PageProvider;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.AclManager;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.cache.CachingManager;
import org.apache.wiki.diff.DifferenceManager;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.pages.PageLock;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.pages.PageSorter;
import org.apache.wiki.pages.PageTimeComparator;
import org.apache.wiki.providers.RepositoryModifiedException;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.tasks.TasksManager;
import org.apache.wiki.ui.CommandResolver;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.DecisionRequiredException;
import org.apache.wiki.workflow.Fact;
import org.apache.wiki.workflow.Step;
import org.apache.wiki.workflow.Workflow;
import org.apache.wiki.workflow.WorkflowBuilder;

public class DefaultPageManager
implements PageManager {
    private static final Logger LOG = LogManager.getLogger(DefaultPageManager.class);
    private final PageProvider m_provider;
    private final Engine m_engine;
    private final int m_expiryTime;
    protected final ConcurrentHashMap<String, PageLock> m_pageLocks = new ConcurrentHashMap();
    private final PageSorter pageSorter = new PageSorter();
    private LockReaper m_reaper;

    public DefaultPageManager(Engine engine, Properties props) throws NoSuchElementException, WikiException {
        this.m_engine = engine;
        boolean useCache = ((CachingManager)this.m_engine.getManager(CachingManager.class)).enabled("jspwiki.pageCache");
        this.m_expiryTime = TextUtil.parseIntParameter((String)props.getProperty("jspwiki.lockExpiryTime"), (int)60);
        String classname = useCache ? "org.apache.wiki.providers.CachingProvider" : TextUtil.getRequiredProperty((Properties)props, (String)"jspwiki.pageProvider");
        this.pageSorter.initialize(props);
        try {
            LOG.debug("Page provider class: '{}'", (Object)classname);
            this.m_provider = (PageProvider)ClassUtil.buildInstance((String)"org.apache.wiki.providers", (String)classname);
            LOG.debug("Initializing page provider class {}", (Object)this.m_provider);
            this.m_provider.initialize(this.m_engine, props);
        }
        catch (ReflectiveOperationException e) {
            LOG.error("Unable to instantiate provider class '{}' ({})", (Object)classname, (Object)e.getMessage(), (Object)e);
            throw new WikiException("Illegal provider class. (" + e.getMessage() + ")", (Throwable)e);
        }
        catch (NoRequiredPropertyException e) {
            LOG.error("Provider did not found a property it was looking for: {}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error("An I/O exception occurred while trying to create a new page provider: {}", (Object)classname, (Object)e);
            throw new WikiException("Unable to start page provider: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public PageProvider getProvider() {
        return this.m_provider;
    }

    @Override
    public Collection<Page> getAllPages() throws ProviderException {
        return this.m_provider.getAllPages();
    }

    @Override
    public String getPageText(String pageName, int version) throws ProviderException {
        String text;
        if (pageName == null || pageName.isEmpty()) {
            throw new ProviderException("Illegal page name");
        }
        try {
            text = this.m_provider.getPageText(pageName, version);
        }
        catch (RepositoryModifiedException e) {
            LOG.info("Repository has been modified externally while fetching page " + pageName);
            Page p = this.m_provider.getPageInfo(pageName, version);
            ((ReferenceManager)this.m_engine.getManager(ReferenceManager.class)).updateReferences(p);
            this.fireEvent(28, p.getName());
            text = this.m_provider.getPageText(pageName, version);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPureText(String page, int version) {
        String result = null;
        try {
            result = this.getPageText(page, version);
        }
        catch (ProviderException e) {
            LOG.error("ProviderException getPureText for page " + page + " [version " + version + "]", (Throwable)e);
        }
        finally {
            if (result == null) {
                result = "";
            }
        }
        return result;
    }

    @Override
    public String getText(String page, int version) {
        String result = this.getPureText(page, version);
        return TextUtil.replaceEntities((String)result);
    }

    @Override
    public void saveText(Context context, String text) throws WikiException {
        Page page = context.getPage();
        String oldText = this.getPureText(page);
        String proposedText = TextUtil.normalizePostData((String)text);
        if (oldText != null && oldText.equals(proposedText)) {
            return;
        }
        boolean allowEmpty = TextUtil.getBooleanProperty((Properties)this.m_engine.getWikiProperties(), (String)"jspwiki.allowCreationOfEmptyPages", (boolean)false);
        if (!allowEmpty && !this.wikiPageExists(page) && text.trim().equals("")) {
            return;
        }
        WorkflowBuilder builder = WorkflowBuilder.getBuilder(this.m_engine);
        Principal submitter = context.getCurrentUser();
        Step prepTask = ((TasksManager)this.m_engine.getManager(TasksManager.class)).buildPreSaveWikiPageTask(proposedText);
        Step completionTask = ((TasksManager)this.m_engine.getManager(TasksManager.class)).buildSaveWikiPageTask();
        String diffText = ((DifferenceManager)this.m_engine.getManager(DifferenceManager.class)).makeDiff(context, oldText, proposedText);
        boolean isAuthenticated = context.getWikiSession().isAuthenticated();
        Fact[] facts = new Fact[]{new Fact("fact.pageName", (Serializable)((Object)page.getName())), new Fact("fact.diffText", (Serializable)((Object)diffText)), new Fact("fact.proposedText", (Serializable)((Object)proposedText)), new Fact("fact.currentText", (Serializable)((Object)oldText)), new Fact("fact.isAuthenticated", Boolean.valueOf(isAuthenticated))};
        String rejectKey = isAuthenticated ? "notification.saveWikiPage.reject" : null;
        Workflow workflow = builder.buildApprovalWorkflow(submitter, "workflow.saveWikiPage", prepTask, "decision.saveWikiPage", facts, completionTask, rejectKey);
        workflow.start(context);
        if (workflow.getCurrentStep() instanceof Decision) {
            throw new DecisionRequiredException("The page contents must be approved before they become active.");
        }
    }

    protected Engine getEngine() {
        return this.m_engine;
    }

    @Override
    public void putPageText(Page page, String content) throws ProviderException {
        if (page == null || page.getName() == null || page.getName().isEmpty()) {
            throw new ProviderException("Illegal page name");
        }
        this.m_provider.putPageText(page, content);
    }

    @Override
    public PageLock lockPage(Page page, String user) {
        if (this.m_reaper == null) {
            this.m_reaper = new LockReaper(this.m_engine);
            this.m_reaper.start();
        }
        this.fireEvent(10, page.getName());
        PageLock lock = this.m_pageLocks.get(page.getName());
        if (lock == null) {
            Date d = new Date();
            lock = new PageLock(page, user, d, new Date(d.getTime() + (long)(this.m_expiryTime * 60) * 1000L));
            this.m_pageLocks.put(page.getName(), lock);
            LOG.debug("Locked page " + page.getName() + " for " + user);
        } else {
            LOG.debug("Page " + page.getName() + " already locked by " + lock.getLocker());
            lock = null;
        }
        return lock;
    }

    @Override
    public void unlockPage(PageLock lock) {
        if (lock == null) {
            return;
        }
        this.m_pageLocks.remove(lock.getPage());
        LOG.debug("Unlocked page " + lock.getPage());
        this.fireEvent(11, lock.getPage());
    }

    @Override
    public PageLock getCurrentLock(Page page) {
        return this.m_pageLocks.get(page.getName());
    }

    @Override
    public List<PageLock> getActiveLocks() {
        return new ArrayList<PageLock>(this.m_pageLocks.values());
    }

    @Override
    public Page getPage(String pagereq) {
        return this.getPage(pagereq, -1);
    }

    @Override
    public Page getPage(String pagereq, int version) {
        try {
            Page p = this.getPageInfo(pagereq, version);
            if (p == null) {
                p = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).getAttachmentInfo(null, pagereq);
            }
            return p;
        }
        catch (ProviderException e) {
            LOG.error("Unable to fetch page info for " + pagereq + " [version " + version + "]", (Throwable)e);
            return null;
        }
    }

    @Override
    public Page getPageInfo(String pageName, int version) throws ProviderException {
        Page page;
        if (pageName == null || pageName.isEmpty()) {
            throw new ProviderException("Illegal page name '" + pageName + "'");
        }
        try {
            page = this.m_provider.getPageInfo(pageName, version);
        }
        catch (RepositoryModifiedException e) {
            LOG.info("Repository has been modified externally while fetching info for " + pageName);
            page = this.m_provider.getPageInfo(pageName, version);
            if (page != null) {
                ((ReferenceManager)this.m_engine.getManager(ReferenceManager.class)).updateReferences(page);
            }
            ((ReferenceManager)this.m_engine.getManager(ReferenceManager.class)).pageRemoved(Wiki.contents().page(this.m_engine, pageName));
        }
        return page;
    }

    @Override
    public <T extends Page> List<T> getVersionHistory(String pageName) {
        List<Attachment> c = null;
        try {
            if (this.pageExists(pageName)) {
                c = this.m_provider.getVersionHistory(pageName);
            }
            if (c == null) {
                c = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).getVersionHistory(pageName);
            }
        }
        catch (ProviderException e) {
            LOG.error("ProviderException requesting version history for " + pageName, (Throwable)e);
        }
        return c;
    }

    @Override
    public String getCurrentProvider() {
        return this.getProvider().getClass().getName();
    }

    @Override
    public String getProviderDescription() {
        return this.m_provider.getProviderInfo();
    }

    @Override
    public int getTotalPageCount() {
        try {
            return this.m_provider.getAllPages().size();
        }
        catch (ProviderException e) {
            LOG.error("Unable to count pages: ", (Throwable)e);
            return -1;
        }
    }

    @Override
    public Set<Page> getRecentChanges() {
        try {
            TreeSet<Page> sortedPages = new TreeSet<Page>(new PageTimeComparator());
            sortedPages.addAll(this.getAllPages());
            sortedPages.addAll(((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).getAllAttachments());
            return sortedPages;
        }
        catch (ProviderException e) {
            LOG.error("Unable to fetch all pages: ", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public boolean pageExists(String pageName) throws ProviderException {
        if (pageName == null || pageName.isEmpty()) {
            throw new ProviderException("Illegal page name");
        }
        return this.m_provider.pageExists(pageName);
    }

    @Override
    public boolean pageExists(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.isEmpty()) {
            throw new ProviderException("Illegal page name");
        }
        if (version == -1) {
            return this.pageExists(pageName);
        }
        return this.m_provider.pageExists(pageName, version);
    }

    @Override
    public boolean wikiPageExists(String page) {
        if (((CommandResolver)this.m_engine.getManager(CommandResolver.class)).getSpecialPageReference(page) != null) {
            return true;
        }
        Attachment att = null;
        try {
            if (this.m_engine.getFinalPageName(page) != null) {
                return true;
            }
            att = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).getAttachmentInfo(null, page);
        }
        catch (ProviderException e) {
            LOG.debug("pageExists() failed to find attachments", (Throwable)e);
        }
        return att != null;
    }

    @Override
    public boolean wikiPageExists(String page, int version) throws ProviderException {
        if (((CommandResolver)this.m_engine.getManager(CommandResolver.class)).getSpecialPageReference(page) != null) {
            return true;
        }
        boolean isThere = false;
        String finalName = this.m_engine.getFinalPageName(page);
        if (finalName != null) {
            isThere = this.pageExists(finalName, version);
        }
        if (!isThere) {
            try {
                isThere = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).getAttachmentInfo(null, page, version) != null;
            }
            catch (ProviderException e) {
                LOG.debug("wikiPageExists() failed to find attachments", (Throwable)e);
            }
        }
        return isThere;
    }

    @Override
    public void deleteVersion(Page page) throws ProviderException {
        if (page instanceof Attachment) {
            ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).deleteVersion((Attachment)page);
        } else {
            this.m_provider.deleteVersion(page.getName(), page.getVersion());
        }
    }

    @Override
    public void deletePage(String pageName) throws ProviderException {
        Page p = this.getPage(pageName);
        if (p != null) {
            if (p instanceof Attachment) {
                ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).deleteAttachment((Attachment)p);
            } else {
                Collection<String> refTo = ((ReferenceManager)this.m_engine.getManager(ReferenceManager.class)).findRefersTo(pageName);
                if (((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).hasAttachments(p)) {
                    List<Attachment> attachments = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).listAttachments(p);
                    for (Attachment attachment : attachments) {
                        if (refTo != null) {
                            refTo.remove(attachment.getName());
                        }
                        ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).deleteAttachment(attachment);
                    }
                }
                this.deletePage(p);
                this.fireEvent(27, pageName);
            }
        }
    }

    @Override
    public void deletePage(Page page) throws ProviderException {
        this.fireEvent(26, page.getName());
        this.m_provider.deletePage(page.getName());
        this.fireEvent(27, page.getName());
    }

    protected final void fireEvent(int type, String pagename) {
        if (WikiEventManager.isListening((Object)this)) {
            WikiEventManager.fireEvent((Object)this, (WikiEvent)new WikiPageEvent((Object)this.m_engine, type, pagename));
        }
    }

    public void actionPerformed(WikiEvent event) {
        if (!(event instanceof WikiSecurityEvent)) {
            return;
        }
        WikiSecurityEvent se = (WikiSecurityEvent)event;
        if (se.getType() == 54) {
            UserProfile[] profiles = (UserProfile[])se.getTarget();
            Principal[] oldPrincipals = new Principal[]{new WikiPrincipal(profiles[0].getLoginName()), new WikiPrincipal(profiles[0].getFullname()), new WikiPrincipal(profiles[0].getWikiName())};
            WikiPrincipal newPrincipal = new WikiPrincipal(profiles[1].getFullname());
            try {
                int pagesChanged = 0;
                Collection<Page> pages = this.getAllPages();
                for (Page page : pages) {
                    boolean aclChanged = this.changeAcl(page, oldPrincipals, newPrincipal);
                    if (!aclChanged) continue;
                    try {
                        ((AclManager)this.m_engine.getManager(AclManager.class)).setPermissions(page, page.getAcl());
                    }
                    catch (WikiSecurityException e) {
                        LOG.error("Could not change page ACL for page " + page.getName() + ": " + e.getMessage(), (Throwable)((Object)e));
                    }
                    ++pagesChanged;
                }
                LOG.info("Profile name change for '" + newPrincipal + "' caused " + pagesChanged + " page ACLs to change also.");
            }
            catch (ProviderException e) {
                LOG.error("Could not change user name in Page ACLs because of Provider error:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected boolean changeAcl(Page page, Principal[] oldPrincipals, Principal newPrincipal) {
        Acl acl = page.getAcl();
        boolean pageChanged = false;
        if (acl != null) {
            Enumeration entries = acl.aclEntries();
            ArrayList<AclEntry> entriesToAdd = new ArrayList<AclEntry>();
            ArrayList<AclEntry> entriesToRemove = new ArrayList<AclEntry>();
            while (entries.hasMoreElements()) {
                AclEntry entry = (AclEntry)entries.nextElement();
                if (!ArrayUtils.contains((Object[])oldPrincipals, (Object)entry.getPrincipal())) continue;
                AclEntry newEntry = Wiki.acls().entry();
                newEntry.setPrincipal(newPrincipal);
                Enumeration permissions = entry.permissions();
                while (permissions.hasMoreElements()) {
                    Permission permission = (Permission)permissions.nextElement();
                    newEntry.addPermission(permission);
                }
                pageChanged = true;
                entriesToRemove.add(entry);
                entriesToAdd.add(newEntry);
            }
            for (AclEntry entry : entriesToRemove) {
                acl.removeEntry(entry);
            }
            for (AclEntry entry : entriesToAdd) {
                acl.addEntry(entry);
            }
        }
        return pageChanged;
    }

    @Override
    public PageSorter getPageSorter() {
        return this.pageSorter;
    }

    private class LockReaper
    extends WikiBackgroundThread {
        public LockReaper(Engine engine) {
            super(engine, 60);
            this.setName("JSPWiki Lock Reaper");
        }

        @Override
        public void backgroundTask() {
            Collection<PageLock> entries = DefaultPageManager.this.m_pageLocks.values();
            Iterator<PageLock> i = entries.iterator();
            while (i.hasNext()) {
                PageLock p = i.next();
                if (!p.isExpired()) continue;
                i.remove();
                LOG.debug("Reaped lock: " + p.getPage() + " by " + p.getLocker() + ", acquired " + p.getAcquisitionTime() + ", and expired " + p.getExpiryTime());
            }
        }
    }
}

