/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils.threading.impl;

import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.blueprint.utils.threading.impl.Discardable;

public class DiscardableCallable<V>
implements Callable<V>,
Runnable,
Discardable<Runnable> {
    private AtomicReference<Callable<V>> c = new AtomicReference();
    private Queue<Discardable<Runnable>> _removeFromListOnCall;

    public DiscardableCallable(Callable<V> call, Queue<Discardable<Runnable>> _unprocessedWork) {
        this.c.set(call);
        this._removeFromListOnCall = _unprocessedWork;
        this._removeFromListOnCall.add(this);
    }

    private DiscardableCallable(Callable<V> call) {
        this.c.set(call);
        this._removeFromListOnCall = new LinkedBlockingQueue<Discardable<Runnable>>();
    }

    @Override
    public Runnable discard() {
        this._removeFromListOnCall.remove(this);
        return new DiscardableCallable<V>(this.c.getAndSet(null));
    }

    @Override
    public V call() throws Exception {
        this._removeFromListOnCall.remove(this);
        Callable<V> call = this.c.get();
        if (call != null) {
            return call.call();
        }
        throw new CancellationException();
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

