/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.whiteboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.aries.jmx.whiteboard.MBeanHolder;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmxWhiteboardSupport {
    static final String PROP_OBJECT_NAME = "jmx.objectname";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MBeanServer[] mbeanServers = new MBeanServer[0];
    private final IdentityHashMap<Object, MBeanHolder> mbeans = new IdentityHashMap();

    JmxWhiteboardSupport() {
    }

    protected synchronized void addMBeanServer(MBeanServer mbeanServer) {
        this.log.debug("addMBeanServer: Adding MBeanServer {}", (Object)mbeanServer);
        ArrayList<MBeanServer> serverList = new ArrayList<MBeanServer>(Arrays.asList(this.mbeanServers));
        serverList.add(mbeanServer);
        this.mbeanServers = serverList.toArray(new MBeanServer[serverList.size()]);
        for (MBeanHolder mbean : this.mbeans.values()) {
            mbean.register(mbeanServer, null);
        }
    }

    protected synchronized void removeMBeanServer(MBeanServer mbeanServer) {
        this.log.debug("removeMBeanServer: Removing MBeanServer {}", (Object)mbeanServer);
        for (MBeanHolder mbean : this.mbeans.values()) {
            mbean.unregister(mbeanServer);
        }
        ArrayList<MBeanServer> serverList = new ArrayList<MBeanServer>(Arrays.asList(this.mbeanServers));
        serverList.remove(mbeanServer);
        this.mbeanServers = serverList.toArray(new MBeanServer[serverList.size()]);
    }

    protected synchronized void registerMBean(Object mbean, ServiceReference props) {
        this.log.debug("registerMBean: Adding MBean {}", mbean);
        ObjectName objectName = this.getObjectName(props);
        if (objectName != null || mbean instanceof MBeanRegistration) {
            MBeanHolder holder = this.createMBeanHolder(mbean, objectName);
            if (holder != null) {
                MBeanServer[] mbeanServers = this.mbeanServers;
                String[] warnExceptions = JmxWhiteboardSupport.getStringPlusProperty(props, "warning.exceptions");
                for (MBeanServer mbeanServer : mbeanServers) {
                    holder.register(mbeanServer, warnExceptions);
                }
                this.mbeans.put(mbean, holder);
            } else {
                this.log.error("registerMBean: Cannot register MBean service {} with MBean servers: Not an instanceof DynamicMBean or not MBean spec compliant standard MBean", mbean);
            }
        } else {
            this.log.error("registerMBean: MBean service {} not registered with valid jmx.objectname propety and not implementing MBeanRegistration interface; not registering with MBean servers", mbean);
        }
    }

    MBeanHolder createMBeanHolder(Object mbean, ObjectName objectName) {
        return MBeanHolder.create(mbean, objectName);
    }

    protected synchronized void unregisterMBean(Object mbean) {
        this.log.debug("unregisterMBean: Removing MBean {}", mbean);
        MBeanHolder holder = this.mbeans.remove(mbean);
        if (holder != null) {
            holder.unregister();
        }
    }

    private ObjectName getObjectName(ServiceReference props) {
        Object oName = props.getProperty(PROP_OBJECT_NAME);
        if (oName instanceof ObjectName) {
            return (ObjectName)oName;
        }
        if (oName instanceof String) {
            try {
                return new ObjectName((String)oName);
            }
            catch (MalformedObjectNameException e) {
                this.log.error("getObjectName: Provided ObjectName property " + oName + " cannot be used as an ObjectName", (Throwable)e);
            }
        } else {
            this.log.info("getObjectName: Missing {} service property (or wrong type); registering if MBean is MBeanRegistration implementation", (Object)PROP_OBJECT_NAME);
        }
        return null;
    }

    private static String[] getStringPlusProperty(ServiceReference<?> ref, String propertyName) {
        Object res;
        Object prop = ref.getProperty(propertyName);
        if (prop == null) {
            res = null;
        } else if (prop instanceof String) {
            res = new String[]{(String)prop};
        } else if (prop instanceof Collection) {
            Object[] col = ((Collection)prop).toArray();
            res = new String[col.length];
            for (int i = 0; i < ((String[])res).length; ++i) {
                res[i] = String.valueOf(col[i]);
            }
        } else {
            res = prop.getClass().isArray() && String.class.equals(prop.getClass().getComponentType()) ? (String[])prop : null;
        }
        return res;
    }
}

