/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.StringTokenizer;

public class Utils {
    public static File getKarafHome(Class<?> mainClass, String karafHomeProperty, String karafHomeEnv) throws IOException {
        int start;
        String classpath;
        int index;
        URL url;
        File rc = null;
        String path = System.getProperty(karafHomeProperty);
        if (path != null) {
            rc = Utils.validateDirectoryExists(path, "Invalid " + karafHomeProperty + " system property", false, true);
        }
        if (rc == null && (path = System.getenv(karafHomeEnv)) != null) {
            rc = Utils.validateDirectoryExists(path, "Invalid " + karafHomeEnv + " environment variable", false, true);
        }
        if (rc == null && (url = mainClass.getClassLoader().getResource(mainClass.getName().replace(".", "/") + ".class")) != null) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                url = jarConnection.getJarFileURL();
                rc = new File(new URI(url.toString())).getCanonicalFile().getParentFile().getParentFile();
            }
            catch (Exception jarConnection) {
                // empty catch block
            }
        }
        if (rc == null && (index = (classpath = System.getProperty("java.class.path")).toLowerCase().indexOf("karaf.jar")) >= (start = classpath.lastIndexOf(File.pathSeparator, index) + 1)) {
            String jarLocation = classpath.substring(start, index);
            rc = new File(jarLocation).getCanonicalFile().getParentFile();
        }
        if (rc == null) {
            throw new IOException("The Karaf install directory could not be determined.  Please set the " + karafHomeProperty + " system property or the " + karafHomeEnv + " environment variable.");
        }
        return rc;
    }

    public static File validateDirectoryExists(String path, String errPrefix, boolean createDirectory, boolean validate) {
        File rc;
        try {
            rc = new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : " + e.getMessage());
        }
        if (!rc.exists() && !createDirectory && validate) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : does not exist");
        }
        if (!rc.exists() && createDirectory) {
            try {
                rc.mkdirs();
            }
            catch (SecurityException se) {
                throw new IllegalArgumentException(errPrefix + " '" + path + "' : " + se.getMessage());
            }
        }
        if (rc.exists() && !rc.isDirectory()) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : is not a directory");
        }
        return rc;
    }

    public static File getKarafDirectory(String directoryProperty, String directoryEnvironmentVariable, File defaultValue, boolean create, boolean validate) {
        File rc = null;
        String path = System.getProperty(directoryProperty);
        if (path != null) {
            rc = Utils.validateDirectoryExists(path, "Invalid " + directoryProperty + " system property", create, validate);
        }
        if (rc == null && (path = System.getenv(directoryEnvironmentVariable)) != null && validate) {
            rc = Utils.validateDirectoryExists(path, "Invalid " + directoryEnvironmentVariable + " environment variable", create, validate);
        }
        if (rc == null) {
            rc = defaultValue;
        }
        return rc;
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        Utils.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                Utils.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            Utils.deleteDirectory(file);
        } else {
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + file);
            }
            if (!file.delete()) {
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static String[] convertToMavenUrlsIfNeeded(String location, boolean convertToMavenUrls) {
        String[] parts = location.split("\\|");
        if (convertToMavenUrls) {
            if (!parts[1].startsWith("mvn:")) {
                String[] p = parts[1].split("/");
                if (p.length >= 4 && p[p.length - 1].startsWith(p[p.length - 3] + "-" + p[p.length - 2])) {
                    String artifactId = p[p.length - 3];
                    String version = p[p.length - 2];
                    String artifactIdVersion = artifactId + "-" + version;
                    StringBuilder sb = new StringBuilder();
                    String classifier = p[p.length - 1].charAt(artifactIdVersion.length()) == '-' ? p[p.length - 1].substring(artifactIdVersion.length() + 1, p[p.length - 1].lastIndexOf(46)) : null;
                    String type = p[p.length - 1].substring(p[p.length - 1].lastIndexOf(46) + 1);
                    sb.append("mvn:");
                    for (int j = 0; j < p.length - 3; ++j) {
                        if (j > 0) {
                            sb.append('.');
                        }
                        sb.append(p[j]);
                    }
                    sb.append('/').append(artifactId).append('/').append(version);
                    if (!"jar".equals(type) || classifier != null) {
                        sb.append('/');
                        if (!"jar".equals(type)) {
                            sb.append(type);
                        }
                        if (classifier != null) {
                            sb.append('/').append(classifier);
                        }
                    }
                    parts[1] = parts[0];
                    parts[0] = sb.toString();
                } else {
                    parts[1] = parts[0];
                }
            } else {
                String tmp = parts[0];
                parts[0] = parts[1];
                parts[1] = tmp;
            }
        } else {
            parts[1] = parts[0];
        }
        return parts;
    }

    public static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuilder tokBuf = new StringBuilder(10);
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                String tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuilder(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }
}

