/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl.logger;

import org.apache.felix.configurator.impl.logger.LogServiceEnabledLogger;
import org.osgi.framework.BundleContext;

public final class SystemLogger {
    private static volatile LogServiceEnabledLogger LOGGER;

    public static void init(BundleContext bundleContext) {
        LOGGER = new LogServiceEnabledLogger(bundleContext);
    }

    public static void destroy() {
        if (LOGGER != null) {
            LOGGER.close();
            LOGGER = null;
        }
    }

    private static void log(int level, String message, Throwable cause) {
        LogServiceEnabledLogger l = LOGGER;
        if (l != null) {
            l.log(level, message, cause);
        }
    }

    public static void debug(String message) {
        SystemLogger.log(4, message, null);
    }

    public static void debug(String message, Throwable cause) {
        SystemLogger.log(4, message, cause);
    }

    public static void info(String message) {
        SystemLogger.log(3, message, null);
    }

    public static void warning(String message) {
        SystemLogger.log(2, message, null);
    }

    public static void warning(String message, Throwable cause) {
        SystemLogger.log(2, message, cause);
    }

    public static void error(String message) {
        SystemLogger.log(1, message, null);
    }

    public static void error(String message, Throwable cause) {
        SystemLogger.log(1, message, cause);
    }
}

