/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.AnnotationInfo;
import aQute.bnd.classfile.ConstantPool;
import aQute.bnd.classfile.ElementValueInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class TypeAnnotationInfo
extends AnnotationInfo {
    public static final int TYPEUSE_INDEX_NONE = -1;
    public static final int TYPEUSE_TARGET_INDEX_EXTENDS = 65535;
    public final int target_type;
    public final byte[] target_info;
    public final int target_index;
    public final byte[] type_path;

    public TypeAnnotationInfo(int target_type, byte[] target_info, int target_index, byte[] type_path, String type, ElementValueInfo[] values) {
        super(type, values);
        this.target_type = target_type;
        this.target_info = target_info;
        this.target_index = target_index;
        this.type_path = type_path;
    }

    @Override
    public String toString() {
        return this.type + " " + Arrays.toString(this.values);
    }

    static TypeAnnotationInfo read(DataInput in, ConstantPool constant_pool) throws IOException {
        int target_index;
        byte[] target_info;
        int target_type = in.readUnsignedByte();
        switch (target_type) {
            case 0: 
            case 1: {
                target_info = new byte[1];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]);
                break;
            }
            case 16: {
                target_info = new byte[2];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]) << 8 | Byte.toUnsignedInt(target_info[1]);
                break;
            }
            case 17: 
            case 18: {
                target_info = new byte[2];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                target_info = new byte[]{};
                target_index = -1;
                break;
            }
            case 22: {
                target_info = new byte[1];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]);
                break;
            }
            case 23: {
                target_info = new byte[2];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]) << 8 | Byte.toUnsignedInt(target_info[1]);
                break;
            }
            case 64: 
            case 65: {
                int table_length = in.readUnsignedShort();
                target_info = new byte[table_length * 6];
                in.readFully(target_info);
                target_index = -1;
                break;
            }
            case 66: {
                target_info = new byte[2];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]) << 8 | Byte.toUnsignedInt(target_info[1]);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                target_info = new byte[2];
                in.readFully(target_info);
                target_index = -1;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                target_info = new byte[3];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[2]);
                break;
            }
            default: {
                throw new IOException("Unknown target_type: " + target_type);
            }
        }
        int path_length = in.readUnsignedByte();
        byte[] type_path = new byte[path_length * 2];
        in.readFully(type_path);
        return TypeAnnotationInfo.read(in, constant_pool, (type, values) -> new TypeAnnotationInfo(target_type, target_info, target_index, type_path, type, values));
    }

    @Override
    void write(DataOutput out, ConstantPool constant_pool) throws IOException {
        out.writeByte(this.target_type);
        switch (this.target_type) {
            case 0: 
            case 1: {
                out.write(this.target_info, 0, 1);
                break;
            }
            case 16: {
                out.write(this.target_info, 0, 2);
                break;
            }
            case 17: 
            case 18: {
                out.write(this.target_info, 0, 2);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                out.write(this.target_info, 0, 1);
                break;
            }
            case 23: {
                out.write(this.target_info, 0, 2);
                break;
            }
            case 64: 
            case 65: {
                int table_length = this.target_info.length / 6;
                out.writeShort(table_length);
                out.write(this.target_info, 0, this.target_info.length);
                break;
            }
            case 66: {
                out.write(this.target_info, 0, 2);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                out.write(this.target_info, 0, 2);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                out.write(this.target_info, 0, 3);
                break;
            }
            default: {
                throw new IOException("Unknown target_type: " + this.target_type);
            }
        }
        int path_length = this.type_path.length / 2;
        out.writeByte(path_length);
        out.write(this.type_path, 0, this.type_path.length);
        super.write(out, constant_pool);
    }

    @Override
    int value_length() {
        int value_length = 1;
        switch (this.target_type) {
            case 0: 
            case 1: {
                ++value_length;
                break;
            }
            case 16: {
                value_length += 2;
                break;
            }
            case 17: 
            case 18: {
                value_length += 2;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                ++value_length;
                break;
            }
            case 23: {
                value_length += 2;
                break;
            }
            case 64: 
            case 65: {
                value_length += 2 + this.target_info.length;
                break;
            }
            case 66: {
                value_length += 2;
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                value_length += 2;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                value_length += 3;
                break;
            }
        }
        value_length += 1 + this.type_path.length;
        return value_length += super.value_length();
    }
}

