/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.SshServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshUtils.class);

    public static <S> List<NamedFactory<S>> filter(Class<S> type, Collection<NamedFactory<S>> factories, String[] names) {
        ArrayList<NamedFactory<S>> list = new ArrayList<NamedFactory<S>>();
        for (String name : names) {
            name = name.trim();
            boolean found = false;
            for (NamedFactory<S> factory : factories) {
                if (!factory.getName().equals(name)) continue;
                list.add(factory);
                found = true;
                break;
            }
            if (found) continue;
            LOGGER.warn("Configured " + type.getSimpleName().toLowerCase() + " '" + name + "' not available");
        }
        return list;
    }

    public static List<KeyExchangeFactory> filter(List<KeyExchangeFactory> factories, String[] names) {
        ArrayList<KeyExchangeFactory> list = new ArrayList<KeyExchangeFactory>();
        for (String name : names) {
            name = name.trim();
            boolean found = false;
            for (KeyExchangeFactory factory : factories) {
                if (!factory.getName().equals(name)) continue;
                list.add(factory);
                found = true;
                break;
            }
            if (found) continue;
            LOGGER.warn("Configured KeyExchangeFactory '" + name + "' not available");
        }
        return list;
    }

    public static List<NamedFactory<Mac>> buildMacs(String[] names) {
        return SshUtils.filter(Mac.class, new ServerConfig().getMacFactories(), names);
    }

    public static List<NamedFactory<Cipher>> buildCiphers(String[] names) {
        ServerConfig defaults = new ServerConfig();
        List avail = defaults.getCipherFactories();
        return SshUtils.filter(Cipher.class, avail, names);
    }

    public static List<KeyExchangeFactory> buildKexAlgorithms(String[] names) {
        ServerConfig defaults = new ServerConfig();
        List<KeyExchangeFactory> avail = defaults.getKeyExchangeFactories();
        return SshUtils.filter(avail, names);
    }

    public static List<NamedFactory<Signature>> buildSigAlgorithms(String[] names) {
        ServerConfig defaults = new ServerConfig();
        List avail = defaults.getSignatureAlgorithms();
        return SshUtils.filter(Signature.class, avail, names);
    }

    private static final class ServerConfig
    extends ServerBuilder {
        public ServerConfig() {
            this.build();
        }

        public SshServer build() {
            return this.build(true);
        }

        public SshServer build(boolean isFillWithDefaultValues) {
            if (isFillWithDefaultValues) {
                this.fillWithDefaultValues();
            }
            return null;
        }

        public List<KeyExchangeFactory> getKeyExchangeFactories() {
            return this.keyExchangeFactories;
        }

        public List<NamedFactory<Cipher>> getCipherFactories() {
            return this.cipherFactories;
        }

        public List<NamedFactory<Mac>> getMacFactories() {
            return this.macFactories;
        }

        public List<NamedFactory<Signature>> getSignatureAlgorithms() {
            return this.signatureFactories;
        }
    }
}

