/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.osgi.util.converter.ConversionException;
import org.osgi.util.converter.ConvertingImpl;
import org.osgi.util.converter.DynamicMapLikeFacade;
import org.osgi.util.converter.Util;

class DynamicInterfaceFacade
extends DynamicMapLikeFacade<String, Object> {
    private Map<String, Set<Method>> keys = null;
    private final Object backingObject;
    private final Class<?> theInterface;

    DynamicInterfaceFacade(Object backingObject, Class<?> intf, ConvertingImpl convertingImpl) {
        super(convertingImpl);
        this.backingObject = backingObject;
        this.theInterface = intf;
    }

    @Override
    public Object get(Object key) {
        Set<Method> set = this.getKeys().get(key);
        if (set == null) {
            return null;
        }
        for (Method m : set) {
            if (m.getParameterTypes().length > 0) continue;
            try {
                return m.invoke(this.backingObject, new Object[0]);
            }
            catch (Exception e) {
                if (RuntimeException.class.isAssignableFrom(e.getCause().getClass())) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
        throw new ConversionException("Missing no-arg method for key: " + key);
    }

    @Override
    public Set<String> keySet() {
        return this.getKeys().keySet();
    }

    private Map<String, Set<Method>> getKeys() {
        if (this.keys == null) {
            this.keys = Util.getInterfaceKeys(this.theInterface, this.backingObject);
        }
        return this.keys;
    }
}

