/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.SchemaUtils;

public class Extensions {
    protected static final Pattern DEFINITION_PATTERN = Pattern.compile("(?:(X-[^ ]+)[ ]*(?:'([^']+)'|\\(([^\\)]+)\\))?)+");
    private static final int HASH_CODE_SEED = 1171;
    private final Map<String, List<String>> extensions = new LinkedHashMap<String, List<String>>();

    public Extensions() {
    }

    public Extensions(String name, List<String> values) {
        this.addExtension(name, values);
    }

    public Set<String> getNames() {
        return this.extensions.keySet();
    }

    public List<String> getValues(String name) {
        return this.extensions.get(name);
    }

    public String getValue(String name) {
        List<String> values = this.getValues(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    public Map<String, List<String>> getAllValues() {
        return Collections.unmodifiableMap(this.extensions);
    }

    public void addExtension(String name) {
        this.extensions.put(name, new ArrayList(0));
    }

    public void addExtension(String name, List<String> values) {
        this.extensions.put(name, values);
    }

    public static Extensions parse(String definition) {
        Matcher m = DEFINITION_PATTERN.matcher(definition);
        Extensions exts = new Extensions();
        while (m.find()) {
            String name = m.group(1).trim();
            ArrayList<String> values = new ArrayList<String>(1);
            if (m.group(2) != null) {
                values.add(m.group(2).trim());
            } else if (m.group(3) != null) {
                values.addAll(Arrays.asList(SchemaUtils.parseDescriptors(m.group(3).trim())));
            }
            exts.addExtension(name, values);
        }
        return exts;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.extensions.entrySet()) {
            sb.append(entry.getKey()).append(" ");
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            sb.append(SchemaUtils.formatDescriptors(entry.getValue().toArray(new String[entry.getValue().size()])));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Extensions) {
            Extensions v = (Extensions)o;
            return LdapUtils.areEqual(this.extensions, v.extensions);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(1171, this.extensions);
    }

    public String toString() {
        return String.format("[%s@%d::extensions=%s]", this.getClass().getName(), this.hashCode(), this.extensions);
    }
}

