/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.authentication.addon;

import java.io.IOException;
import java.sql.SQLException;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.impl.StandardReadableByteBuf;
import org.mariadb.jdbc.client.socket.Reader;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.AuthenticationPlugin;
import org.mariadb.jdbc.plugin.authentication.addon.gssapi.GssUtility;
import org.mariadb.jdbc.plugin.authentication.addon.gssapi.GssapiAuth;
import org.mariadb.jdbc.plugin.authentication.addon.gssapi.StandardGssapiAuthentication;

public class SendGssApiAuthPacket
implements AuthenticationPlugin {
    private static final GssapiAuth gssapiAuth;
    private byte[] seed;
    private String optionServicePrincipalName;

    @Override
    public String type() {
        return "auth_gssapi_client";
    }

    @Override
    public void initialize(String authenticationData, byte[] seed, Configuration conf) {
        this.seed = seed;
        this.optionServicePrincipalName = conf.servicePrincipalName();
    }

    @Override
    public ReadableByteBuf process(Writer out, Reader in, Context context) throws IOException, SQLException {
        StandardReadableByteBuf buf = new StandardReadableByteBuf(this.seed, this.seed.length);
        String serverSpn = buf.readStringNullEnd();
        String servicePrincipalName = this.optionServicePrincipalName != null ? this.optionServicePrincipalName : serverSpn;
        String mechanisms = buf.readStringNullEnd();
        if (mechanisms.isEmpty()) {
            mechanisms = "Kerberos";
        }
        gssapiAuth.authenticate(out, in, servicePrincipalName, mechanisms);
        return in.readReusablePacket();
    }

    static {
        GssapiAuth init;
        try {
            init = GssUtility.getAuthenticationMethod();
        }
        catch (Throwable t) {
            init = new StandardGssapiAuthentication();
        }
        gssapiAuth = init;
    }
}

