/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ClientCache;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtobufRpcEngineCallback;
import org.apache.hadoop.ipc.ProtocolMetaInfoPB;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.ResponseBuffer;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.ipc.RpcEngine;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.ipc.RpcNoSuchMethodException;
import org.apache.hadoop.ipc.RpcWritable;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.protobuf.ProtobufRpcEngineProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.tracing.TraceScope;
import org.apache.hadoop.tracing.Tracer;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.concurrent.AsyncGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceStability.Evolving
public class ProtobufRpcEngine
implements RpcEngine {
    public static final Logger LOG = LoggerFactory.getLogger(ProtobufRpcEngine.class);
    private static final ThreadLocal<AsyncGet<Message, Exception>> ASYNC_RETURN_MESSAGE = new ThreadLocal();
    private static final ClientCache CLIENTS;

    @InterfaceStability.Unstable
    public static AsyncGet<Message, Exception> getAsyncReturnMessage() {
        return ASYNC_RETURN_MESSAGE.get();
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, Client.ConnectionId connId, Configuration conf, SocketFactory factory, AlignmentContext alignmentContext) throws IOException {
        Invoker invoker = new Invoker(protocol, connId, conf, factory, alignmentContext);
        return new ProtocolProxy<Object>(protocol, Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)invoker), false);
    }

    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        return this.getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, null);
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy) throws IOException {
        return this.getProxy(protocol, clientVersion, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, null, null);
    }

    @Override
    public <T> ProtocolProxy<T> getProxy(Class<T> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
        Invoker invoker = new Invoker(protocol, addr, ticket, conf, factory, rpcTimeout, connectionRetryPolicy, fallbackToSimpleAuth, alignmentContext);
        return new ProtocolProxy<Object>(protocol, Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)invoker), false);
    }

    @Override
    public ProtocolProxy<ProtocolMetaInfoPB> getProtocolMetaInfoProxy(Client.ConnectionId connId, Configuration conf, SocketFactory factory) throws IOException {
        Class<ProtocolMetaInfoPB> protocol = ProtocolMetaInfoPB.class;
        return new ProtocolProxy<ProtocolMetaInfoPB>(protocol, (ProtocolMetaInfoPB)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, connId, conf, factory, null)), false);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    static Client getClient(Configuration conf) {
        return CLIENTS.getClient(conf, SocketFactory.getDefault(), RpcWritable.Buffer.class);
    }

    @Override
    public RPC.Server getServer(Class<?> protocol, Object protocolImpl, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig, AlignmentContext alignmentContext) throws IOException {
        return new Server(protocol, protocolImpl, conf, bindAddress, port, numHandlers, numReaders, queueSizePerHandler, verbose, secretManager, portRangeConfig, alignmentContext);
    }

    static {
        ProtobufRpcEngine2.registerProtocolEngine();
        CLIENTS = new ClientCache();
    }

    static class RpcProtobufRequest
    extends RpcWritable.Buffer {
        private volatile ProtobufRpcEngineProtos.RequestHeaderProto requestHeader;
        private Message payload;

        public RpcProtobufRequest() {
        }

        RpcProtobufRequest(ProtobufRpcEngineProtos.RequestHeaderProto header, Message payload) {
            this.requestHeader = header;
            this.payload = payload;
        }

        ProtobufRpcEngineProtos.RequestHeaderProto getRequestHeader() throws IOException {
            if (this.getByteBuffer() != null && this.requestHeader == null) {
                this.requestHeader = this.getValue(ProtobufRpcEngineProtos.RequestHeaderProto.getDefaultInstance());
            }
            return this.requestHeader;
        }

        @Override
        public void writeTo(ResponseBuffer out) throws IOException {
            this.requestHeader.writeDelimitedTo(out);
            if (this.payload != null) {
                this.payload.writeDelimitedTo((OutputStream)out);
            }
        }

        public String toString() {
            try {
                ProtobufRpcEngineProtos.RequestHeaderProto header = this.getRequestHeader();
                return header.getDeclaringClassProtocolName() + "." + header.getMethodName();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static class Server
    extends ProtobufRpcEngine2.Server {
        static final ThreadLocal<ProtobufRpcEngineCallback> currentCallback = new ThreadLocal();

        @InterfaceStability.Unstable
        public static ProtobufRpcEngineCallback registerForDeferredResponse() {
            ProtobufRpcEngineCallbackImpl callback = new ProtobufRpcEngineCallbackImpl();
            currentCallback.set(callback);
            return callback;
        }

        public Server(Class<?> protocolClass, Object protocolImpl, Configuration conf, String bindAddress, int port, int numHandlers, int numReaders, int queueSizePerHandler, boolean verbose, SecretManager<? extends TokenIdentifier> secretManager, String portRangeConfig, AlignmentContext alignmentContext) throws IOException {
            super(protocolClass, protocolImpl, conf, bindAddress, port, numHandlers, numReaders, queueSizePerHandler, verbose, secretManager, portRangeConfig, alignmentContext);
        }

        static RpcWritable processCall(RPC.Server server, String connectionProtocolName, RpcWritable.Buffer request, String methodName, RPC.Server.ProtoClassProtoImpl protocolImpl) throws Exception {
            Message result;
            BlockingService service = (BlockingService)protocolImpl.protocolImpl;
            Descriptors.MethodDescriptor methodDescriptor = service.getDescriptorForType().findMethodByName(methodName);
            if (methodDescriptor == null) {
                String msg = "Unknown method " + methodName + " called on " + connectionProtocolName + " protocol.";
                LOG.warn(msg);
                throw new RpcNoSuchMethodException(msg);
            }
            Message prototype = service.getRequestPrototype(methodDescriptor);
            Message param = request.getValue(prototype);
            Server.Call currentCall = Server.getCurCall().get();
            try {
                server.rpcDetailedMetrics.init(protocolImpl.protocolClass);
                CURRENT_CALL_INFO.set(new ProtobufRpcEngine2.Server.CallInfo(server, methodName));
                currentCall.setDetailedMetricsName(methodName);
                result = service.callBlockingMethod(methodDescriptor, null, param);
                if (currentCallback.get() != null) {
                    currentCall.deferResponse();
                    currentCallback.set(null);
                    RpcWritable rpcWritable = null;
                    return rpcWritable;
                }
            }
            catch (ServiceException e) {
                Exception exception = (Exception)e.getCause();
                currentCall.setDetailedMetricsName(exception.getClass().getSimpleName());
                throw (Exception)e.getCause();
            }
            catch (Exception e) {
                currentCall.setDetailedMetricsName(e.getClass().getSimpleName());
                throw e;
            }
            finally {
                CURRENT_CALL_INFO.set(null);
            }
            return RpcWritable.wrap(result);
        }

        static class ProtobufRpcEngineCallbackImpl
        implements ProtobufRpcEngineCallback {
            private final RPC.Server server = ProtobufRpcEngine2.Server.CURRENT_CALL_INFO.get().getServer();
            private final Server.Call call = Server.getCurCall().get();
            private final String methodName = ProtobufRpcEngine2.Server.CURRENT_CALL_INFO.get().getMethodName();
            private final long setupTime = Time.now();

            @Override
            public void setResponse(Message message) {
                long processingTime = Time.now() - this.setupTime;
                this.call.setDeferredResponse(RpcWritable.wrap(message));
                this.server.updateDeferredMetrics(this.methodName, processingTime);
            }

            @Override
            public void error(Throwable t) {
                long processingTime = Time.now() - this.setupTime;
                String detailedMetricsName = t.getClass().getSimpleName();
                this.server.updateDeferredMetrics(detailedMetricsName, processingTime);
                this.call.setDeferredError(t);
            }
        }
    }

    protected static class Invoker
    implements RpcInvocationHandler {
        private final Map<String, Message> returnTypes = new ConcurrentHashMap<String, Message>();
        private boolean isClosed = false;
        private final Client.ConnectionId remoteId;
        private final Client client;
        private final long clientProtocolVersion;
        private final String protocolName;
        private AtomicBoolean fallbackToSimpleAuth;
        private AlignmentContext alignmentContext;

        protected Invoker(Class<?> protocol, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout, RetryPolicy connectionRetryPolicy, AtomicBoolean fallbackToSimpleAuth, AlignmentContext alignmentContext) throws IOException {
            this(protocol, Client.ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, connectionRetryPolicy, conf), conf, factory, alignmentContext);
            this.fallbackToSimpleAuth = fallbackToSimpleAuth;
        }

        protected Invoker(Class<?> protocol, Client.ConnectionId connId, Configuration conf, SocketFactory factory, AlignmentContext alignmentContext) {
            this.remoteId = connId;
            this.client = CLIENTS.getClient(conf, factory, RpcWritable.Buffer.class);
            this.protocolName = RPC.getProtocolName(protocol);
            this.clientProtocolVersion = RPC.getProtocolVersion(protocol);
            this.alignmentContext = alignmentContext;
        }

        private ProtobufRpcEngineProtos.RequestHeaderProto constructRpcRequestHeader(Method method) {
            ProtobufRpcEngineProtos.RequestHeaderProto.Builder builder = ProtobufRpcEngineProtos.RequestHeaderProto.newBuilder();
            builder.setMethodName(method.getName());
            builder.setDeclaringClassProtocolName(this.protocolName);
            builder.setClientProtocolVersion(this.clientProtocolVersion);
            return builder.build();
        }

        public Message invoke(Object proxy, final Method method, Object[] args) throws ServiceException {
            RpcWritable.Buffer val;
            long startTime = 0L;
            if (LOG.isDebugEnabled()) {
                startTime = Time.now();
            }
            if (args.length != 2) {
                throw new ServiceException("Too many or few parameters for request. Method: [" + method.getName() + "], Expected: 2, Actual: " + args.length);
            }
            if (args[1] == null) {
                throw new ServiceException("null param while calling Method: [" + method.getName() + "]");
            }
            Tracer tracer = Tracer.curThreadTracer();
            TraceScope traceScope = null;
            if (tracer != null) {
                traceScope = tracer.newScope(RpcClientUtil.methodToTraceString(method));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(Thread.currentThread().getId() + ": Call -> " + this.remoteId + ": " + method.getName() + " {" + TextFormat.shortDebugString((MessageOrBuilder)((Message)args[1])) + "}");
            }
            Message theRequest = (Message)args[1];
            try {
                val = (RpcWritable.Buffer)this.client.call(RPC.RpcKind.RPC_PROTOCOL_BUFFER, this.constructRpcRequest(method, theRequest), this.remoteId, this.fallbackToSimpleAuth, this.alignmentContext);
            }
            catch (Throwable e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(Thread.currentThread().getId() + ": Exception <- " + this.remoteId + ": " + method.getName() + " {" + e + "}");
                }
                if (traceScope != null) {
                    traceScope.addTimelineAnnotation("Call got exception: " + e.toString());
                }
                throw new ServiceException(e);
            }
            finally {
                if (traceScope != null) {
                    traceScope.close();
                }
            }
            if (LOG.isDebugEnabled()) {
                long callTime = Time.now() - startTime;
                LOG.debug("Call: " + method.getName() + " took " + callTime + "ms");
            }
            if (Client.isAsynchronousMode()) {
                final AsyncGet arr = Client.getAsyncRpcResponse();
                AsyncGet<Message, Exception> asyncGet = new AsyncGet<Message, Exception>(){

                    @Override
                    public Message get(long timeout, TimeUnit unit) throws Exception {
                        return this.getReturnMessage(method, (RpcWritable.Buffer)arr.get(timeout, unit));
                    }

                    @Override
                    public boolean isDone() {
                        return arr.isDone();
                    }
                };
                ASYNC_RETURN_MESSAGE.set(asyncGet);
                return null;
            }
            return this.getReturnMessage(method, val);
        }

        protected Writable constructRpcRequest(Method method, Message theRequest) {
            ProtobufRpcEngineProtos.RequestHeaderProto rpcRequestHeader = this.constructRpcRequestHeader(method);
            return new RpcProtobufRequest(rpcRequestHeader, theRequest);
        }

        private Message getReturnMessage(Method method, RpcWritable.Buffer buf) throws ServiceException {
            Message returnMessage;
            Message prototype = null;
            try {
                prototype = this.getReturnProtoType(method);
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
            try {
                returnMessage = buf.getValue(prototype.getDefaultInstanceForType());
                if (LOG.isTraceEnabled()) {
                    LOG.trace(Thread.currentThread().getId() + ": Response <- " + this.remoteId + ": " + method.getName() + " {" + TextFormat.shortDebugString((MessageOrBuilder)returnMessage) + "}");
                }
            }
            catch (Throwable e) {
                throw new ServiceException(e);
            }
            return returnMessage;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }

        private Message getReturnProtoType(Method method) throws Exception {
            if (this.returnTypes.containsKey(method.getName())) {
                return this.returnTypes.get(method.getName());
            }
            Class<?> returnType = method.getReturnType();
            Method newInstMethod = returnType.getMethod("getDefaultInstance", new Class[0]);
            newInstMethod.setAccessible(true);
            Message prototype = (Message)newInstMethod.invoke(null, (Object[])null);
            this.returnTypes.put(method.getName(), prototype);
            return prototype;
        }

        @Override
        public Client.ConnectionId getConnectionId() {
            return this.remoteId;
        }

        protected long getClientProtocolVersion() {
            return this.clientProtocolVersion;
        }

        protected String getProtocolName() {
            return this.protocolName;
        }
    }
}

