/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestDerefAlias
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestDerefAlias.class);

    public StoreSearchRequestDerefAlias() {
        super("Store SearchRequest derefAlias flag");
    }

    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        SearchRequest searchRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        try {
            int derefAliases = IntegerDecoder.parse((BerValue)value, (int)0, (int)3);
            searchRequest.setDerefAliases(AliasDerefMode.getDerefMode((int)derefAliases));
        }
        catch (IntegerDecoderException ide) {
            String msg = I18n.err((I18n)I18n.ERR_05150_BAD_DEREF_ALIAS, (Object[])new Object[]{value.toString()});
            LOG.error(msg);
            throw new DecoderException(msg, (Throwable)ide);
        }
        if (LOG.isDebugEnabled()) {
            switch (searchRequest.getDerefAliases()) {
                case NEVER_DEREF_ALIASES: {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_05161_HANDLING_OBJECT_STRATEGY, (Object[])new Object[]{"NEVER_DEREF_ALIASES"}));
                    break;
                }
                case DEREF_IN_SEARCHING: {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_05161_HANDLING_OBJECT_STRATEGY, (Object[])new Object[]{"DEREF_IN_SEARCHING"}));
                    break;
                }
                case DEREF_FINDING_BASE_OBJ: {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_05161_HANDLING_OBJECT_STRATEGY, (Object[])new Object[]{"DEREF_FINDING_BASE_OBJ"}));
                    break;
                }
                case DEREF_ALWAYS: {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_05161_HANDLING_OBJECT_STRATEGY, (Object[])new Object[]{"DEREF_ALWAYS"}));
                    break;
                }
                default: {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_05161_HANDLING_OBJECT_STRATEGY, (Object[])new Object[]{"UNKNOWN"}));
                }
            }
        }
    }
}

