/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.search.entryChange;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.LongDecoder;
import org.apache.directory.api.asn1.ber.tlv.LongDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeContainer;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeStates;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntryChangeGrammar
extends AbstractGrammar<EntryChangeContainer> {
    static final Logger LOG = LoggerFactory.getLogger(EntryChangeGrammar.class);
    private static Grammar<?> instance = new EntryChangeGrammar();

    private EntryChangeGrammar() {
        this.setName(EntryChangeGrammar.class.getName());
        this.transitions = new GrammarTransition[EntryChangeStates.LAST_EC_STATE.ordinal()][256];
        this.transitions[EntryChangeStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)EntryChangeStates.START_STATE, (Enum)EntryChangeStates.EC_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[EntryChangeStates.EC_SEQUENCE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)EntryChangeStates.EC_SEQUENCE_STATE, (Enum)EntryChangeStates.CHANGE_TYPE_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new GrammarAction<EntryChangeContainer>("Set EntryChangeControl changeType"){

            public void action(EntryChangeContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int change = IntegerDecoder.parse((BerValue)value, (int)1, (int)8);
                    switch (ChangeType.getChangeType((int)change)) {
                        case ADD: 
                        case DELETE: 
                        case MODDN: 
                        case MODIFY: {
                            ChangeType changeType = ChangeType.getChangeType((int)change);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(I18n.msg((I18n)I18n.MSG_05300_CHANGE_TYPE, (Object[])new Object[]{changeType}));
                            }
                            container.getEntryChange().setChangeType(changeType);
                            break;
                        }
                        default: {
                            String msg = I18n.err((I18n)I18n.ERR_05300_CANT_DECODE_CHANGE_TYPE, (Object[])new Object[0]);
                            LOG.error(msg);
                            throw new DecoderException(msg);
                        }
                    }
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err((I18n)I18n.ERR_05300_CANT_DECODE_CHANGE_TYPE, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)ide);
                    throw new DecoderException(msg, (Throwable)ide);
                }
                catch (IllegalArgumentException iae) {
                    throw new DecoderException(iae.getLocalizedMessage(), (Throwable)iae);
                }
            }
        });
        this.transitions[EntryChangeStates.CHANGE_TYPE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)EntryChangeStates.CHANGE_TYPE_STATE, (Enum)EntryChangeStates.PREVIOUS_DN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<EntryChangeContainer>("Set EntryChangeControl previousDN"){

            public void action(EntryChangeContainer container) throws DecoderException {
                Dn previousDn;
                ChangeType changeType = container.getEntryChange().getChangeType();
                if (changeType != ChangeType.MODDN) {
                    LOG.error(I18n.err((I18n)I18n.ERR_05301_INVALID_PREVIOUS_DN, (Object[])new Object[0]));
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_05302_PREVIOUS_DN_NOT_ALLOWED, (Object[])new Object[0]));
                }
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    previousDn = new Dn(new String[]{Strings.utf8ToString((byte[])value.getData())});
                }
                catch (LdapInvalidDnException ine) {
                    LOG.error(I18n.err((I18n)I18n.ERR_05303_BAD_PREVIOUS_DN, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())}));
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_05304_FAILED_TO_DECODE_PREVIOUS_DN, (Object[])new Object[0]), (Throwable)ine);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_05301_PREVIOUS_DN, (Object[])new Object[]{previousDn}));
                }
                container.getEntryChange().setPreviousDn(previousDn);
                container.setGrammarEndAllowed(true);
            }
        });
        GrammarAction<EntryChangeContainer> setChangeNumberAction = new GrammarAction<EntryChangeContainer>("Set EntryChangeControl changeNumber"){

            public void action(EntryChangeContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    long changeNumber = LongDecoder.parse((BerValue)value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_05302_CHANGE_NUMBER, (Object[])new Object[]{changeNumber}));
                    }
                    container.getEntryChange().setChangeNumber(changeNumber);
                    container.setGrammarEndAllowed(true);
                }
                catch (LongDecoderException lde) {
                    String msg = I18n.err((I18n)I18n.ERR_05305_CHANGE_NUMBER_DECODING_ERROR, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)lde);
                    throw new DecoderException(msg, (Throwable)lde);
                }
            }
        };
        this.transitions[EntryChangeStates.PREVIOUS_DN_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)EntryChangeStates.PREVIOUS_DN_STATE, (Enum)EntryChangeStates.CHANGE_NUMBER_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)setChangeNumberAction);
        this.transitions[EntryChangeStates.CHANGE_TYPE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)EntryChangeStates.CHANGE_TYPE_STATE, (Enum)EntryChangeStates.CHANGE_NUMBER_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)setChangeNumberAction);
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

