/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiWatchedDir;
import com.cloudera.api.swagger.model.ApiWatchedDirList;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class WatchedDirResourceApi {
    private ApiClient apiClient;

    public WatchedDirResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WatchedDirResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addWatchedDirectoryCall(String clusterName, String serviceName, ApiWatchedDir body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiWatchedDir localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/watcheddir".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addWatchedDirectoryValidateBeforeCall(String clusterName, String serviceName, ApiWatchedDir body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling addWatchedDirectory(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling addWatchedDirectory(Async)");
        }
        Call call = this.addWatchedDirectoryCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiWatchedDir addWatchedDirectory(String clusterName, String serviceName, ApiWatchedDir body) throws ApiException {
        ApiResponse<ApiWatchedDir> resp = this.addWatchedDirectoryWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiWatchedDir> addWatchedDirectoryWithHttpInfo(String clusterName, String serviceName, ApiWatchedDir body) throws ApiException {
        Call call = this.addWatchedDirectoryValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiWatchedDir>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addWatchedDirectoryAsync(String clusterName, String serviceName, ApiWatchedDir body, final ApiCallback<ApiWatchedDir> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addWatchedDirectoryValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiWatchedDir>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listWatchedDirectoriesCall(String clusterName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/watcheddir".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listWatchedDirectoriesValidateBeforeCall(String clusterName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling listWatchedDirectories(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling listWatchedDirectories(Async)");
        }
        Call call = this.listWatchedDirectoriesCall(clusterName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiWatchedDirList listWatchedDirectories(String clusterName, String serviceName) throws ApiException {
        ApiResponse<ApiWatchedDirList> resp = this.listWatchedDirectoriesWithHttpInfo(clusterName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiWatchedDirList> listWatchedDirectoriesWithHttpInfo(String clusterName, String serviceName) throws ApiException {
        Call call = this.listWatchedDirectoriesValidateBeforeCall(clusterName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiWatchedDirList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listWatchedDirectoriesAsync(String clusterName, String serviceName, final ApiCallback<ApiWatchedDirList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listWatchedDirectoriesValidateBeforeCall(clusterName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiWatchedDirList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removeWatchedDirectoryCall(String clusterName, String directoryPath, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/watcheddir/{directoryPath}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{directoryPath\\}", this.apiClient.escapeString(directoryPath.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removeWatchedDirectoryValidateBeforeCall(String clusterName, String directoryPath, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling removeWatchedDirectory(Async)");
        }
        if (directoryPath == null) {
            throw new ApiException("Missing the required parameter 'directoryPath' when calling removeWatchedDirectory(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling removeWatchedDirectory(Async)");
        }
        Call call = this.removeWatchedDirectoryCall(clusterName, directoryPath, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiWatchedDir removeWatchedDirectory(String clusterName, String directoryPath, String serviceName) throws ApiException {
        ApiResponse<ApiWatchedDir> resp = this.removeWatchedDirectoryWithHttpInfo(clusterName, directoryPath, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiWatchedDir> removeWatchedDirectoryWithHttpInfo(String clusterName, String directoryPath, String serviceName) throws ApiException {
        Call call = this.removeWatchedDirectoryValidateBeforeCall(clusterName, directoryPath, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiWatchedDir>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removeWatchedDirectoryAsync(String clusterName, String directoryPath, String serviceName, final ApiCallback<ApiWatchedDir> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removeWatchedDirectoryValidateBeforeCall(clusterName, directoryPath, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiWatchedDir>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

