/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments used for the \"disable Catalog Statestore HA\" command. The \"disable Catalog Statestore HA\" command includes disabling catalog and statestore HA, therefore the arguments of it include the required catalog and statestore information.")
public class ApiDisableCatalogStatestoreHaArguments {
    @SerializedName(value="activeCatalogName")
    private String activeCatalogName = null;
    @SerializedName(value="activeStatestoreName")
    private String activeStatestoreName = null;

    public ApiDisableCatalogStatestoreHaArguments activeCatalogName(String activeCatalogName) {
        this.activeCatalogName = activeCatalogName;
        return this;
    }

    @Schema(description="Name of the Catalog role that will be active after HA is disabled.")
    public String getActiveCatalogName() {
        return this.activeCatalogName;
    }

    public void setActiveCatalogName(String activeCatalogName) {
        this.activeCatalogName = activeCatalogName;
    }

    public ApiDisableCatalogStatestoreHaArguments activeStatestoreName(String activeStatestoreName) {
        this.activeStatestoreName = activeStatestoreName;
        return this;
    }

    @Schema(description="Name of the Statestore role that will be active after HA is disabled.")
    public String getActiveStatestoreName() {
        return this.activeStatestoreName;
    }

    public void setActiveStatestoreName(String activeStatestoreName) {
        this.activeStatestoreName = activeStatestoreName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiDisableCatalogStatestoreHaArguments apiDisableCatalogStatestoreHaArguments = (ApiDisableCatalogStatestoreHaArguments)o;
        return Objects.equals(this.activeCatalogName, apiDisableCatalogStatestoreHaArguments.activeCatalogName) && Objects.equals(this.activeStatestoreName, apiDisableCatalogStatestoreHaArguments.activeStatestoreName);
    }

    public int hashCode() {
        return Objects.hash(this.activeCatalogName, this.activeStatestoreName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiDisableCatalogStatestoreHaArguments {\n");
        sb.append("    activeCatalogName: ").append(this.toIndentedString(this.activeCatalogName)).append("\n");
        sb.append("    activeStatestoreName: ").append(this.toIndentedString(this.activeStatestoreName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

