/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiHBaseSnapshotResult;
import com.cloudera.api.swagger.model.ApiHdfsSnapshotResult;
import com.cloudera.api.swagger.model.ApiOzoneSnapshotResult;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Information about snapshot commands. <p/> This object holds all the information a regular ApiCommand object provides, and adds specific information about the results of a snapshot command. <p/> Depending on the type of the service where the snapshot command was run, a different result property will be populated.")
public class ApiSnapshotCommand
extends ApiCommand {
    @SerializedName(value="hbaseResult")
    private ApiHBaseSnapshotResult hbaseResult = null;
    @SerializedName(value="hdfsResult")
    private ApiHdfsSnapshotResult hdfsResult = null;
    @SerializedName(value="ozoneResult")
    private ApiOzoneSnapshotResult ozoneResult = null;

    public ApiSnapshotCommand hbaseResult(ApiHBaseSnapshotResult hbaseResult) {
        this.hbaseResult = hbaseResult;
        return this;
    }

    @Schema(description="")
    public ApiHBaseSnapshotResult getHbaseResult() {
        return this.hbaseResult;
    }

    public void setHbaseResult(ApiHBaseSnapshotResult hbaseResult) {
        this.hbaseResult = hbaseResult;
    }

    public ApiSnapshotCommand hdfsResult(ApiHdfsSnapshotResult hdfsResult) {
        this.hdfsResult = hdfsResult;
        return this;
    }

    @Schema(description="")
    public ApiHdfsSnapshotResult getHdfsResult() {
        return this.hdfsResult;
    }

    public void setHdfsResult(ApiHdfsSnapshotResult hdfsResult) {
        this.hdfsResult = hdfsResult;
    }

    public ApiSnapshotCommand ozoneResult(ApiOzoneSnapshotResult ozoneResult) {
        this.ozoneResult = ozoneResult;
        return this;
    }

    @Schema(description="")
    public ApiOzoneSnapshotResult getOzoneResult() {
        return this.ozoneResult;
    }

    public void setOzoneResult(ApiOzoneSnapshotResult ozoneResult) {
        this.ozoneResult = ozoneResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiSnapshotCommand apiSnapshotCommand = (ApiSnapshotCommand)o;
        return Objects.equals(this.hbaseResult, apiSnapshotCommand.hbaseResult) && Objects.equals(this.hdfsResult, apiSnapshotCommand.hdfsResult) && Objects.equals(this.ozoneResult, apiSnapshotCommand.ozoneResult) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hbaseResult, this.hdfsResult, this.ozoneResult, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiSnapshotCommand {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    hbaseResult: ").append(this.toIndentedString(this.hbaseResult)).append("\n");
        sb.append("    hdfsResult: ").append(this.toIndentedString(this.hdfsResult)).append("\n");
        sb.append("    ozoneResult: ").append(this.toIndentedString(this.ozoneResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

