/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import org.apache.shiro.crypto.hash.SimpleHashRequest;
import org.apache.shiro.util.ByteSource;

public interface HashRequest {
    public ByteSource getSource();

    public ByteSource getSalt();

    public int getIterations();

    public String getAlgorithmName();

    public static class Builder {
        private ByteSource source;
        private ByteSource salt;
        private int iterations = 0;
        private String algorithmName;

        public Builder setSource(ByteSource source) {
            this.source = source;
            return this;
        }

        public Builder setSource(Object source) throws IllegalArgumentException {
            this.source = ByteSource.Util.bytes(source);
            return this;
        }

        public Builder setSalt(ByteSource salt) {
            this.salt = salt;
            return this;
        }

        public Builder setSalt(Object salt) throws IllegalArgumentException {
            this.salt = ByteSource.Util.bytes(salt);
            return this;
        }

        public Builder setIterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public HashRequest build() {
            return new SimpleHashRequest(this.algorithmName, this.source, this.salt, this.iterations);
        }
    }
}

