/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction;

import java.util.List;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionResponseStates;
import org.apache.directory.api.ldap.extras.extended.endTransaction.UpdateControls;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTransactionResponseGrammar
extends AbstractGrammar<EndTransactionResponseContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(EndTransactionResponseGrammar.class);
    private static Grammar<EndTransactionResponseContainer> instance = new EndTransactionResponseGrammar();

    public EndTransactionResponseGrammar() {
        this.setName(EndTransactionResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[EndTransactionResponseStates.LAST_STATE.ordinal()][256];
        this.transitions[EndTransactionResponseStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)EndTransactionResponseStates.START_STATE, (Enum)EndTransactionResponseStates.END_TRANSACTION_SEQUENCE_STATE, UniversalTag.SEQUENCE, (Action)new GrammarAction<EndTransactionResponseContainer>("Init EndTransactionResponse"){

            public void action(EndTransactionResponseContainer container) {
                if (container.getCurrentTLV().getLength() == 0) {
                    container.setGrammarEndAllowed(true);
                }
            }
        });
        this.transitions[EndTransactionResponseStates.END_TRANSACTION_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)EndTransactionResponseStates.END_TRANSACTION_SEQUENCE_STATE, (Enum)EndTransactionResponseStates.FAILED_MESSAGE_ID_STATE, UniversalTag.INTEGER, (Action)new GrammarAction<EndTransactionResponseContainer>("Set EndTransactionResponse failed MessageID"){

            public void action(EndTransactionResponseContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int failedMessageId = IntegerDecoder.parse((BerValue)value);
                    if (failedMessageId > 0) {
                        container.getEndTransactionResponse().setFailedMessageId(failedMessageId);
                    }
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException ide) {
                    LOG.error(I18n.err((I18n)I18n.ERR_08221_BAD_END_TRANSACTION_COMMIT, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), ide.getMessage()}));
                    throw new DecoderException(ide.getMessage(), (Throwable)ide);
                }
            }
        });
        this.transitions[EndTransactionResponseStates.END_TRANSACTION_SEQUENCE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)EndTransactionResponseStates.END_TRANSACTION_SEQUENCE_STATE, (Enum)EndTransactionResponseStates.UPDATE_CONTROLS_SEQ_STATE, UniversalTag.SEQUENCE);
        this.transitions[EndTransactionResponseStates.UPDATE_CONTROLS_SEQ_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)EndTransactionResponseStates.UPDATE_CONTROLS_SEQ_STATE, (Enum)EndTransactionResponseStates.UPDATE_CONTROL_SEQ_STATE, UniversalTag.SEQUENCE, (Action)new GrammarAction<EndTransactionResponseContainer>("Create an updateControl"){

            public void action(EndTransactionResponseContainer container) {
                UpdateControls currentUpdateControls = new UpdateControls();
                container.setCurrentControls(currentUpdateControls);
            }
        });
        this.transitions[EndTransactionResponseStates.UPDATE_CONTROL_SEQ_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)EndTransactionResponseStates.UPDATE_CONTROL_SEQ_STATE, (Enum)EndTransactionResponseStates.CONTROL_MESSAGE_ID_STATE, UniversalTag.INTEGER, (Action)new GrammarAction<EndTransactionResponseContainer>("Get the updateControl messageId"){

            public void action(EndTransactionResponseContainer container) throws DecoderException {
                UpdateControls currentUpdateControls = container.getCurrentUpdateControls();
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int messageId = IntegerDecoder.parse((BerValue)value);
                    currentUpdateControls.setMessageId(messageId);
                    container.setGathering(true);
                }
                catch (IntegerDecoderException ide) {
                    LOG.error(I18n.err((I18n)I18n.ERR_08222_BAD_END_TRANSACTION_MESSAGE_ID, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), ide.getMessage()}));
                    throw new DecoderException(ide.getMessage(), (Throwable)ide);
                }
            }
        });
        this.transitions[EndTransactionResponseStates.CONTROL_MESSAGE_ID_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)EndTransactionResponseStates.CONTROL_MESSAGE_ID_STATE, (Enum)EndTransactionResponseStates.CONTROLS_STATE, UniversalTag.SEQUENCE, (Action)new GrammarAction<EndTransactionResponseContainer>("Process the controls"){

            public void action(EndTransactionResponseContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                container.setGathering(false);
                try {
                    List<Control> controls = EndTransactionResponseContainer.decode(value.getData());
                    UpdateControls currentUpdateControls = container.getCurrentUpdateControls();
                    currentUpdateControls.setControls(controls);
                    container.getEndTransactionResponse().getUpdateControls().add(currentUpdateControls);
                }
                catch (DecoderException de) {
                    LOG.error(I18n.err((I18n)I18n.ERR_08223_INVALID_CONTROL_LIST, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), de.getMessage()}));
                    throw new DecoderException(de.getMessage(), (Throwable)de);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[EndTransactionResponseStates.CONTROLS_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)EndTransactionResponseStates.CONTROLS_STATE, (Enum)EndTransactionResponseStates.UPDATE_CONTROL_SEQ_STATE, UniversalTag.SEQUENCE, (Action)new GrammarAction<EndTransactionResponseContainer>("Get the updateControl messageId"){

            public void action(EndTransactionResponseContainer container) {
                UpdateControls currentUpdateControls = new UpdateControls();
                container.setCurrentControls(currentUpdateControls);
            }
        });
    }

    public static Grammar<EndTransactionResponseContainer> getInstance() {
        return instance;
    }
}

