/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.derby.impl.drda.CcsidManager;

public class Utf8CcsidManager
extends CcsidManager {
    public Utf8CcsidManager() {
        super((byte)32, (byte)46, new byte[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42, -41});
    }

    @Override
    public byte[] convertFromJavaString(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Override
    public String convertToJavaString(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Override
    public String convertToJavaString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Override
    public void convertFromJavaString(String string, ByteBuffer byteBuffer) {
        byteBuffer.put(this.convertFromJavaString(string));
    }

    @Override
    int getByteLength(String string) {
        try {
            return string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return -1;
        }
    }
}

