/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter.zip;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.exporter.AbstractOnDemandInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ZipOnDemandInputStream
extends AbstractOnDemandInputStream<ZipOutputStream> {
    private boolean compressed;
    private static long SYSTIME = System.currentTimeMillis();

    ZipOnDemandInputStream(Archive<?> archive) {
        super(archive);
        this.compressed = true;
    }

    ZipOnDemandInputStream(Archive<?> archive, boolean compressed) {
        super(archive);
        this.compressed = compressed;
    }

    @Override
    protected ZipOutputStream createOutputStream(OutputStream outputStream) {
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        if (!this.compressed) {
            zos.setLevel(0);
        }
        return zos;
    }

    @Override
    protected void closeEntry(ZipOutputStream outputStream) throws IOException {
        outputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putNextEntry(ZipOutputStream outputStream, String context, Asset asset) throws IOException {
        ZipEntry zipEntry = new ZipEntry(context);
        if (!this.compressed) {
            zipEntry.setMethod(0);
            zipEntry.setTime(SYSTIME);
            long contentSize = 0L;
            long crc = 0L;
            if (asset != null) {
                CRC32 crc32 = new CRC32();
                byte[] buf = new byte[1024];
                BufferedInputStream is = null;
                try {
                    int len;
                    is = new BufferedInputStream(asset.openStream());
                    while ((len = ((InputStream)is).read(buf, 0, buf.length)) != -1) {
                        crc32.update(buf, 0, len);
                        contentSize += (long)len;
                    }
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                crc = crc32.getValue();
            }
            zipEntry.setCrc(crc);
            zipEntry.setSize(contentSize);
        }
        outputStream.putNextEntry(zipEntry);
    }
}

