/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.util.CommonHelper;

public class IpExtractor
implements CredentialsExtractor<TokenCredentials> {
    private List<String> alternateIpHeaders = Collections.emptyList();
    private String proxyIp = "";

    public IpExtractor() {
    }

    public IpExtractor(String ... alternateIpHeaders) {
        this.alternateIpHeaders = Arrays.asList(alternateIpHeaders);
    }

    public Optional<TokenCredentials> extract(WebContext context) {
        Optional<String> ip;
        if (this.alternateIpHeaders.isEmpty()) {
            ip = Optional.ofNullable(context.getRemoteAddr());
        } else {
            String requestSourceIp = context.getRemoteAddr();
            ip = this.proxyIp.isEmpty() ? this.ipFromHeaders(context) : (this.proxyIp.equals(requestSourceIp) ? this.ipFromHeaders(context) : Optional.empty());
        }
        if (!ip.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new TokenCredentials(ip.get()));
    }

    private Optional<String> ipFromHeaders(WebContext context) {
        for (String header : this.alternateIpHeaders) {
            Optional ip = context.getRequestHeader(header);
            if (!ip.isPresent() || ((String)ip.get()).isEmpty()) continue;
            return ip;
        }
        return Optional.empty();
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public void setProxyIp(String proxyIp) {
        this.proxyIp = proxyIp == null ? "" : proxyIp;
    }

    public List getAlternateIpHeaders() {
        return Collections.unmodifiableList(this.alternateIpHeaders);
    }

    public void setAlternateIpHeaders(String ... alternateIpHeaders) {
        CommonHelper.assertNotNull((String)"alternateIpHeaders", (Object)alternateIpHeaders);
        this.alternateIpHeaders = Arrays.asList(alternateIpHeaders);
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), (Object[])new Object[]{"alternateIpHeaders", Arrays.asList(this.alternateIpHeaders)});
    }
}

