/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.trace;

import org.apache.knox.gateway.trace.TraceUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class AccessHandler
extends AbstractLifeCycle
implements RequestLog {
    private static final Logger log = LogManager.getLogger((String)"org.apache.knox.gateway.access");

    public void log(Request request, Response response) {
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            TraceUtil.appendCorrelationContext(sb);
            sb.append('|').append(request.getRemoteAddr()).append('|').append(request.getMethod()).append('|').append(request.getHttpURI()).append('|').append(request.getContentLength()).append('|').append(response.getStatus()).append('|').append(response.getContentCount()).append('|').append(System.currentTimeMillis() - request.getTimeStamp());
            log.trace((CharSequence)sb);
        }
    }
}

