/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

public class ExplicitList<T> {
    private Link<T> head = new Link<Object>(null);
    private int listSize = 0;

    public void remove(Link<T> link) {
        if (this.listSize <= 0) {
            throw new IllegalStateException("Trying to remove link " + link + " from a list with no elements");
        }
        --this.listSize;
        link.remove();
    }

    public void addFirst(Link<T> link) {
        ++this.listSize;
        link.addAfter(this.head);
    }

    public void addLast(Link<T> link) {
        ++this.listSize;
        link.addBefore(this.head);
    }

    public Link<T> begin() {
        return this.head.getNext();
    }

    public Link<T> end() {
        return this.head;
    }

    public int size() {
        return this.listSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("List: ");
        sb.append("(size: ").append(this.listSize).append(")");
        sb.append("\n");
        return sb.toString();
    }

    public static class Link<V> {
        private V element;
        private Link<V> next;
        private Link<V> prev;

        public Link(V element) {
            this.element = element;
            this.reset();
        }

        public Link<V> getNext() {
            return this.next;
        }

        public void setNext(Link<V> next) {
            this.next = next;
        }

        public Link<V> getPrev() {
            return this.prev;
        }

        public void setPrev(Link<V> prev) {
            this.prev = prev;
        }

        public void remove() {
            if (!this.isLinked()) {
                throw new IllegalStateException("Trying to remove from list an unlinked link");
            }
            this.getPrev().setNext(this.getNext());
            this.getNext().setPrev(this.getPrev());
            this.reset();
        }

        public void addAfter(Link<V> after) {
            if (!this.isUnLinked()) {
                throw new IllegalStateException("Trying to add to list already linked link: " + this);
            }
            after.getNext().setPrev(this);
            this.setNext(after.getNext());
            after.setNext(this);
            this.setPrev(after);
        }

        public void addBefore(Link<V> before) {
            if (!this.isUnLinked()) {
                throw new IllegalStateException("Trying to add to list already linked link: " + this);
            }
            before.getPrev().setNext(this);
            this.setPrev(before.getPrev());
            before.setPrev(this);
            this.setNext(before);
        }

        public void splice(Link<V> listHead) {
            Link<V> prevLink = listHead.getPrev();
            listHead.setPrev(this);
            prevLink.setNext(this);
            this.setNext(listHead);
            this.setPrev(prevLink);
        }

        public boolean isUnLinked() {
            return this.prev == this && this.next == this;
        }

        public boolean isLinked() {
            return !this.isUnLinked();
        }

        public void reset() {
            this.next = this;
            this.prev = this;
        }

        public void uninit() {
            if (!this.isUnLinked()) {
                throw new IllegalStateException(" Unitializing a still linked entry" + this);
            }
            this.element = null;
        }

        public V getElement() {
            return this.element;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Link: ").append(this).append(" ");
            sb.append("(next: ").append(this.next);
            sb.append(",prev: ").append(this.prev).append(")");
            sb.append("\n");
            return sb.toString();
        }
    }
}

