/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.api;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.filter.AbstractGatewayFilter;
import org.apache.knox.gateway.filter.rewrite.impl.CookieScopeResponseWrapper;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class CookieScopeServletFilter
extends AbstractGatewayFilter {
    private static final GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private String gatewayPath;
    private String topologyName;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.gatewayPath = filterConfig.getInitParameter("gateway.path");
        this.topologyName = filterConfig.getInitParameter("topologyName");
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (Boolean.parseBoolean((String)request.getAttribute("defaultTopologyForward"))) {
            LOG.ignoringCookiePathScopeForDefaultTopology();
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)new CookieScopeResponseWrapper(response, this.gatewayPath, this.topologyName));
        }
    }
}

