/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.directory.mavibot.btree.BTreeHeader;
import org.apache.directory.mavibot.btree.RecordManager;

public class ReadTransaction<K, V> {
    private long revision;
    private long creationDate;
    private BTreeHeader<K, V> btreeHeader;
    private volatile boolean closed;
    private ConcurrentLinkedQueue<ReadTransaction<K, V>> readTransactions;
    private RecordManager recordManager;

    public ReadTransaction(RecordManager recordManager, BTreeHeader<K, V> btreeHeader, ConcurrentLinkedQueue<ReadTransaction<K, V>> readTransactions) {
        if (btreeHeader != null) {
            this.revision = btreeHeader.getRevision();
            this.creationDate = System.currentTimeMillis();
            this.btreeHeader = btreeHeader;
            this.recordManager = recordManager;
            this.closed = false;
        }
        this.readTransactions = readTransactions;
    }

    public ReadTransaction(BTreeHeader<K, V> btreeHeader, ConcurrentLinkedQueue<ReadTransaction<K, V>> readTransactions) {
        if (btreeHeader != null) {
            this.revision = btreeHeader.getRevision();
            this.creationDate = System.currentTimeMillis();
            this.btreeHeader = btreeHeader;
            this.closed = false;
        }
        this.readTransactions = readTransactions;
    }

    public long getRevision() {
        return this.revision;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public BTreeHeader<K, V> getBtreeHeader() {
        return this.btreeHeader;
    }

    public void close() {
        this.closed = true;
        this.readTransactions.remove(this);
        if (this.recordManager != null) {
            this.recordManager.releaseTransaction(this);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "Transaction[" + this.revision + ":" + new Date(this.creationDate) + ", closed :" + this.closed + "]";
    }
}

