/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Session;

public class OracleOCIProxyConnector
extends JNDIConnector {
    public OracleOCIProxyConnector() {
    }

    public OracleOCIProxyConnector(Context context, String name) throws ValidationException {
        super(context, name);
    }

    public OracleOCIProxyConnector(String name) {
        super(name);
    }

    public OracleOCIProxyConnector(OracleOCIConnectionPool oracleOCIConnectionPool) {
        super((DataSource)oracleOCIConnectionPool);
    }

    @Override
    public Connection connect(Properties properties, Session session) throws DatabaseException, ValidationException {
        String proxytype = properties.getProperty("proxytype");
        if (proxytype == null || proxytype.length() == 0) {
            return super.connect(properties, session);
        }
        try {
            OracleOCIConnectionPool oracleOCIConnectionPool = (OracleOCIConnectionPool)this.getDataSource();
            if (oracleOCIConnectionPool == null) {
                try {
                    oracleOCIConnectionPool = (OracleOCIConnectionPool)this.getContext().lookup(this.getName());
                    this.setDataSource((DataSource)oracleOCIConnectionPool);
                }
                catch (NamingException exception) {
                    throw ValidationException.cannotAcquireDataSource(this.getName(), exception);
                }
            }
            return oracleOCIConnectionPool.getProxyConnection(proxytype, properties);
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, true);
        }
        catch (ClassCastException classCastException) {
            throw ValidationException.oracleOCIProxyConnectorRequiresOracleOCIConnectionPool();
        }
    }
}

