/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shirorealm;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;

public class KnoxLdapContextFactory
extends JndiLdapContextFactory {
    private static GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private String systemAuthenticationMechanism = "simple";
    private String clusterName = "";

    public KnoxLdapContextFactory() {
        this.setAuthenticationMechanism("simple");
    }

    protected LdapContext createLdapContext(Hashtable env) throws NamingException {
        if (this.getSystemUsername() != null && this.getSystemUsername().equals(env.get("java.naming.security.principal"))) {
            env.put("java.naming.security.authentication", this.getSystemAuthenticationMechanism());
        }
        return super.createLdapContext(env);
    }

    public String getSystemAuthenticationMechanism() {
        return this.systemAuthenticationMechanism != null ? this.systemAuthenticationMechanism : this.getAuthenticationMechanism();
    }

    public void setSystemAuthenticationMechanism(String systemAuthenticationMechanism) {
        this.systemAuthenticationMechanism = systemAuthenticationMechanism;
    }

    public void setSystemPassword(String systemPass) {
        if (systemPass == null) {
            return;
        }
        if ((systemPass = systemPass.trim()).isEmpty()) {
            return;
        }
        if (!systemPass.startsWith("S{ALIAS=")) {
            super.setSystemPassword(systemPass);
            return;
        }
        String aliasName = systemPass = systemPass.substring("S{ALIAS=".length(), systemPass.length() - 1);
        GatewayServices services = GatewayServer.getGatewayServices();
        AliasService aliasService = (AliasService)services.getService(ServiceType.ALIAS_SERVICE);
        String clusterName = this.getClusterName();
        char[] password = null;
        try {
            password = aliasService.getPasswordFromAliasForCluster(clusterName, systemPass);
        }
        catch (AliasServiceException e) {
            LOG.unableToGetPassword((Exception)((Object)e));
        }
        if (password != null) {
            super.setSystemPassword(new String(password));
        } else {
            super.setSystemPassword("");
            LOG.aliasValueNotFound(clusterName, aliasName);
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        if (clusterName != null) {
            this.clusterName = clusterName.trim();
        }
    }
}

