/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.deploy.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.DeploymentException;
import org.apache.knox.gateway.deploy.DeploymentFactory;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributor;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class CompositeAuthzDeploymentContributor
extends ProviderDeploymentContributorBase {
    public String getRole() {
        return "authorization";
    }

    public String getName() {
        return "CompositeAuthz";
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        if (params == null) {
            params = new ArrayList<FilterParamDescriptor>();
        }
        Map providerParams = provider.getParams();
        String providerNames = (String)providerParams.get("composite.provider.names");
        List<String> names = this.parseProviderNames(providerNames);
        for (String name : names) {
            this.getProviderSpecificParams(resource, params, providerParams, name);
            ProviderDeploymentContributor contributor = DeploymentFactory.getProviderContributor((String)"authorization", (String)name);
            if (contributor == null) {
                throw new DeploymentException("Invalid composite provider name: " + name + " role: " + provider.getRole() + " provider: " + provider.getName() + " topology: " + context.getTopology().getName());
            }
            contributor.contributeFilter(context, provider, service, resource, params);
            params.clear();
        }
    }

    List<String> parseProviderNames(String providerNames) {
        if (StringUtils.isBlank((CharSequence)providerNames)) {
            return Collections.emptyList();
        }
        List<String> providerNamesList = Arrays.asList(providerNames.split("\\s*,\\s*"));
        providerNamesList.replaceAll(String::trim);
        return providerNamesList;
    }

    void getProviderSpecificParams(ResourceDescriptor resource, List<FilterParamDescriptor> params, Map<String, String> providerParams, String name) {
        for (Map.Entry<String, String> entry : providerParams.entrySet()) {
            if (!entry.getKey().startsWith(name + ".")) continue;
            String entryName = entry.getKey().substring(entry.getKey().indexOf(46) + 1);
            FilterParamDescriptor fpd = resource.createFilterParam();
            params.add(fpd.name(entryName.toLowerCase(Locale.ROOT)).value(entry.getValue()));
        }
    }
}

