/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

class SetConstraintsNode
extends MiscellaneousStatementNode {
    private final List<TableName> constraints;
    private final boolean deferred;

    SetConstraintsNode(List<TableName> list, boolean bl, ContextManager contextManager) {
        super(contextManager);
        this.constraints = list;
        this.deferred = bl;
    }

    @Override
    public String toString() {
        return "";
    }

    String formatList(List<TableName> list) {
        return "";
    }

    @Override
    public String statementToString() {
        return "SET CONSTRAINTS";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetConstraintsConstantAction(this.constraints, this.deferred);
    }

    @Override
    public void bindStatement() throws StandardException {
        if (this.constraints != null) {
            for (TableName tableName : this.constraints) {
                tableName.bind();
            }
        }
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.constraints != null) {
            for (int i = 0; i < this.constraints.size(); ++i) {
                this.constraints.set(i, (TableName)this.constraints.get(i).accept(visitor));
            }
        }
    }
}

