/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.actions;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.hostAddresses.HostAddressesContainer;
import org.apache.directory.shared.kerberos.components.HostAddresses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadHostAddresses<E extends Asn1Container>
extends GrammarAction<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadHostAddresses.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AbstractReadHostAddresses(String name) {
        super(name);
    }

    protected abstract void setHostAddresses(HostAddresses var1, E var2);

    public final void action(E container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_01308_ZERO_LENGTH_TLV, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_01309_EMPTY_TLV, (Object[])new Object[0]));
        }
        HostAddressesContainer hostAddressesContainer = new HostAddressesContainer();
        hostAddressesContainer.setStream(container.getStream());
        Asn1Decoder.decode((ByteBuffer)container.getStream(), (Asn1Container)hostAddressesContainer);
        HostAddresses hostAddresses = hostAddressesContainer.getHostAddresses();
        this.setHostAddresses(hostAddresses, container);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        container.updateParent();
        if (IS_DEBUG) {
            LOG.debug("HostAddresses : {}", (Object)hostAddresses);
        }
    }
}

