/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.extractor;

import com.github.scribejava.core.exceptions.OAuthException;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.exception.OAuthCredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class OAuthCredentialsExtractor<C extends OAuthCredentials, O extends OAuthConfiguration>
implements CredentialsExtractor<C> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected O configuration;
    protected IndirectClient client;

    protected OAuthCredentialsExtractor(O configuration, IndirectClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)client);
        CommonHelper.assertNotNull((String)"configuration", configuration);
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<C> extract(WebContext context) {
        boolean hasBeenCancelled = (Boolean)((OAuthConfiguration)((Object)this.configuration)).getHasBeenCancelledFactory().apply(context);
        if (hasBeenCancelled) {
            this.logger.debug("authentication has been cancelled by user");
            return Optional.empty();
        }
        try {
            boolean errorFound = false;
            OAuthCredentialsException oauthCredentialsException = new OAuthCredentialsException("Failed to retrieve OAuth credentials, error parameters found");
            for (String key : OAuthCredentialsException.ERROR_NAMES) {
                Optional value = context.getRequestParameter(key);
                if (!value.isPresent()) continue;
                errorFound = true;
                oauthCredentialsException.setErrorMessage(key, (String)value.get());
            }
            if (errorFound) {
                throw oauthCredentialsException;
            }
            return this.getOAuthCredentials(context);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected abstract Optional<C> getOAuthCredentials(WebContext var1);
}

