/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.future;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HandshakeFuture
implements Future<Boolean> {
    private volatile boolean done = false;
    protected boolean cancelled = false;

    public synchronized void cancel() {
        this.cancelled = true;
        this.notifyAll();
    }

    public synchronized void secured() {
        this.done = true;
        this.notifyAll();
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled) {
            return this.cancelled;
        }
        this.cancelled = true;
        this.notifyAll();
        return this.cancelled;
    }

    @Override
    public synchronized Boolean get() throws InterruptedException, ExecutionException {
        while (!this.done && !this.cancelled) {
            this.wait();
        }
        return this.done;
    }

    @Override
    public synchronized Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done && !this.cancelled) {
            this.wait(unit.toMillis(timeout));
        }
        return this.done;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HandshakeFuture, completed: ").append(this.done).append(", cancelled: ").append(this.cancelled);
        return sb.toString();
    }
}

