/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.gson.NullableTypeAdapter;
import io.gsonfire.util.JsonUtils;
import io.gsonfire.util.Mapper;
import java.io.IOException;
import java.util.Map;

public class WrapTypeAdapterFactory<T>
implements TypeAdapterFactory {
    private final Map<Class<T>, Mapper<T, String>> wrappedClasses;

    public WrapTypeAdapterFactory(Map<Class<T>, Mapper<T, String>> wrappedClasses) {
        this.wrappedClasses = wrappedClasses;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        TypeAdapter originalTypeAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        Mapper<T, String> mapper = this.getMostSpecificMapper(type.getRawType());
        if (mapper == null) {
            return originalTypeAdapter;
        }
        return new NullableTypeAdapter<T>(new WrapperTypeAdapter<T>(mapper, gson, originalTypeAdapter));
    }

    private Mapper<T, String> getMostSpecificMapper(Class clazz) {
        Mapper<T, String> mostSpecificMapper = null;
        for (Class mostSpecificClass = clazz; mostSpecificClass != null; mostSpecificClass = mostSpecificClass.getSuperclass()) {
            mostSpecificMapper = this.wrappedClasses.get(mostSpecificClass);
            if (mostSpecificMapper == null) continue;
            return mostSpecificMapper;
        }
        return null;
    }

    private class WrapperTypeAdapter<T>
    extends TypeAdapter<T> {
        private final Mapper<T, String> mapper;
        private final Gson gson;
        private final TypeAdapter<T> originalTypeAdapter;

        public WrapperTypeAdapter(Mapper<T, String> mapper, Gson gson, TypeAdapter<T> originalTypeAdapter) {
            this.mapper = mapper;
            this.gson = gson;
            this.originalTypeAdapter = originalTypeAdapter;
        }

        public void write(JsonWriter out, T src) throws IOException {
            if (src == null) {
                this.originalTypeAdapter.write(out, src);
            } else {
                String value = this.mapper.map(src);
                JsonElement unwrappedObj = JsonUtils.toJsonTree(this.originalTypeAdapter, out, src);
                JsonObject wrappedObj = new JsonObject();
                wrappedObj.add(value, unwrappedObj);
                this.gson.toJson((JsonElement)wrappedObj, out);
            }
        }

        public T read(JsonReader in) throws IOException {
            in.beginObject();
            in.nextName();
            Object unwrappedObj = this.originalTypeAdapter.read(in);
            in.endObject();
            return (T)unwrappedObj;
        }
    }
}

