/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.eclipse.jetty.util.component.LifeCycle;

public class GatewayServerLifecycleListener
implements LifeCycle.Listener {
    private static final GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault()));
    private final Path lifeCycleFilePath;

    GatewayServerLifecycleListener(GatewayConfig gatewayConfig) throws IOException {
        this.lifeCycleFilePath = Paths.get(gatewayConfig.getGatewayDataDir(), "gatewayServer.status");
        Files.deleteIfExists(this.lifeCycleFilePath);
        Files.createFile(this.lifeCycleFilePath, new FileAttribute[0]);
    }

    public void lifeCycleStarting(LifeCycle event) {
        this.saveStatus(Status.STARTING);
    }

    public void lifeCycleStarted(LifeCycle event) {
        this.saveStatus(Status.STARTED);
    }

    public void lifeCycleFailure(LifeCycle event, Throwable cause) {
        this.saveStatus(Status.FAILURE);
    }

    public void lifeCycleStopping(LifeCycle event) {
        this.saveStatus(Status.STOPPING);
    }

    public void lifeCycleStopped(LifeCycle event) {
        this.saveStatus(Status.STOPPED);
    }

    private void saveStatus(Status status) {
        try {
            String message = DATE_FORMAT.get().format(new Date()) + System.getProperty("line.separator") + status.name() + System.getProperty("line.separator");
            Files.write(this.lifeCycleFilePath, message.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            log.failedToSaveGatewayStatus();
        }
    }

    private static enum Status {
        STARTING,
        STARTED,
        FAILURE,
        STOPPING,
        STOPPED;

    }
}

