/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.preauth.filter;

import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.preauth.filter.PreAuthValidationException;
import org.apache.knox.gateway.preauth.filter.PreAuthValidator;
import org.apache.knox.gateway.util.IpAddressValidator;

public class IPValidator
implements PreAuthValidator {
    public static final String IP_ADDRESSES_PARAM = "preauth.ip.addresses";
    public static final String IP_VALIDATION_METHOD_VALUE = "preauth.ip.validation";

    @Override
    public boolean validate(HttpServletRequest httpRequest, FilterConfig filterConfig) throws PreAuthValidationException {
        String ipParam = filterConfig.getInitParameter(IP_ADDRESSES_PARAM);
        IpAddressValidator ipv = new IpAddressValidator(ipParam);
        return ipv.validateIpAddress(httpRequest.getRemoteAddr());
    }

    @Override
    public String getName() {
        return IP_VALIDATION_METHOD_VALUE;
    }
}

