/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.knox.gateway.service.admin.beans.Topology;

@Provider
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public class TopologyMarshaller
implements MessageBodyWriter<Topology>,
MessageBodyReader<Topology> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Topology.class == type;
    }

    public long getSize(Topology instance, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Topology instance, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("eclipselink.media-type", mediaType.toString());
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Topology.class}, properties);
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)instance, entityStream);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == Topology.class;
    }

    public Topology readFrom(Class<Topology> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Topology topology = null;
        try {
            if (this.isReadable(type, genericType, annotations, mediaType)) {
                Map properties = Collections.emptyMap();
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Topology.class}, properties);
                Unmarshaller u = context.createUnmarshaller();
                u.setProperty("eclipselink.media-type", (Object)(mediaType.getType() + "/" + mediaType.getSubtype()));
                if (mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                    XMLInputFactory xif = XMLInputFactory.newFactory();
                    xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                    xif.setProperty("javax.xml.stream.supportDTD", false);
                    xif.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
                    XMLStreamReader xsr = xif.createXMLStreamReader(new StreamSource(entityStream));
                    topology = (Topology)u.unmarshal(xsr);
                } else {
                    topology = (Topology)u.unmarshal(entityStream);
                }
            }
        }
        catch (JAXBException | XMLStreamException e) {
            throw new IOException(e);
        }
        return topology;
    }
}

