/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariComponent;
import org.apache.knox.gateway.topology.discovery.ambari.SparkCommonServiceURLCreator;

public class SparkHistoryUIServiceURLCreator
extends SparkCommonServiceURLCreator {
    private static final String RESOURCE_ROLE = "SPARKHISTORYUI";
    private static final String SSL_FLAG_PRIMARY = "spark.ssl.historyServer.enabled";
    private static final String SSL_FLAG_SECONDARY = "spark.ssl.enabled";
    private static final String SSL_PORT_PROPERTY = "spark.ssl.historyServer.port";
    private static final int SSL_PORT_OFFSET = 400;

    @Override
    public void init(AmbariCluster cluster) {
        super.init(cluster);
        this.primaryComponentName = "SPARK_JOBHISTORYSERVER";
        this.secondaryComponentName = "SPARK2_JOBHISTORYSERVER";
        this.portConfigProperty = "spark.history.ui.port";
    }

    @Override
    public String getTargetService() {
        return RESOURCE_ROLE;
    }

    @Override
    String getPort(AmbariComponent comp) {
        String port;
        if (this.isSSL(comp)) {
            String sslPort = comp.getConfigProperty(SSL_PORT_PROPERTY);
            if (sslPort == null || sslPort.isEmpty()) {
                int p = Integer.parseInt(comp.getConfigProperty(this.portConfigProperty)) + 400;
                sslPort = String.valueOf(p);
            }
            port = sslPort;
        } else {
            port = comp.getConfigProperty(this.portConfigProperty);
        }
        return port;
    }

    @Override
    boolean isSSL(AmbariComponent comp) {
        return Boolean.valueOf(comp.getConfigProperty(SSL_FLAG_PRIMARY)) != false || Boolean.valueOf(comp.getConfigProperty(SSL_FLAG_SECONDARY)) != false;
    }
}

