/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.common.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.knox.gateway.IdentityAsserterMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.plang.AbstractSyntaxTree;
import org.apache.knox.gateway.plang.Arity;
import org.apache.knox.gateway.plang.Interpreter;

public class VirtualGroupMapper {
    public static final String PRIMARY_GROUP = "$PRIMARY_GROUP";
    private final IdentityAsserterMessages LOG = (IdentityAsserterMessages)MessagesFactory.get(IdentityAsserterMessages.class);
    private final Map<String, AbstractSyntaxTree> virtualGroupToPredicateMap;

    public VirtualGroupMapper(Map<String, AbstractSyntaxTree> virtualGroupToPredicateMap) {
        this.virtualGroupToPredicateMap = virtualGroupToPredicateMap;
    }

    public Set<String> mapGroups(String username, Set<String> groups, ServletRequest request) {
        HashSet<String> virtualGroups = new HashSet<String>();
        for (Map.Entry<String, AbstractSyntaxTree> each : this.virtualGroupToPredicateMap.entrySet()) {
            AbstractSyntaxTree predicate;
            String virtualGroupName = each.getKey();
            if (!this.evalPredicate(virtualGroupName = this.resolveLogicalGroupName(username, virtualGroupName), username, groups, predicate = each.getValue(), request)) continue;
            virtualGroups.add(virtualGroupName);
            this.LOG.addingUserToVirtualGroup(username, virtualGroupName, predicate);
        }
        this.LOG.virtualGroups(username, groups, virtualGroups);
        return virtualGroups;
    }

    private String resolveLogicalGroupName(String username, String virtualGroupName) {
        if (PRIMARY_GROUP.equalsIgnoreCase(virtualGroupName)) {
            virtualGroupName = username;
        }
        return virtualGroupName;
    }

    private boolean evalPredicate(String virtualGroupName, String userName, Set<String> ldapGroups, AbstractSyntaxTree predicate, ServletRequest request) {
        Interpreter interpreter = new Interpreter();
        interpreter.addConstant("username", (Object)userName);
        interpreter.addConstant("groups", new ArrayList<String>(ldapGroups));
        VirtualGroupMapper.addRequestFunctions(request, interpreter);
        this.LOG.checkingVirtualGroup(userName, ldapGroups, virtualGroupName, predicate);
        Object result = interpreter.eval(predicate);
        if (!(result instanceof Boolean)) {
            this.LOG.invalidResult(virtualGroupName, predicate, result);
            return false;
        }
        return (Boolean)result;
    }

    public static void addRequestFunctions(ServletRequest req, Interpreter interpreter) {
        if (req instanceof HttpServletRequest) {
            interpreter.addFunction("request-attribute", Arity.UNARY, params -> VirtualGroupMapper.ensureNotNull(req.getAttribute((String)params.get(0))));
            interpreter.addFunction("request-header", Arity.UNARY, params -> VirtualGroupMapper.ensureNotNull(((HttpServletRequest)req).getHeader((String)params.get(0))));
            interpreter.addFunction("session", Arity.UNARY, params -> VirtualGroupMapper.ensureNotNull(VirtualGroupMapper.sessionAttribute((HttpServletRequest)req, (String)params.get(0))));
        }
    }

    private static String ensureNotNull(Object value) {
        return value == null ? "" : value.toString();
    }

    private static Object sessionAttribute(HttpServletRequest req, String key) {
        HttpSession session = req.getSession(false);
        return session != null ? session.getAttribute(key) : "";
    }
}

