/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.Comparator;

public class Tuple<K, V>
implements Comparable<Tuple<K, V>> {
    protected K key;
    protected V value;
    protected Comparator<K> keyComparator;

    public Tuple() {
    }

    public Tuple(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public Tuple(K key, V value, Comparator<K> keyComparator) {
        this.key = key;
        this.value = value;
        this.keyComparator = keyComparator;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tuple)) {
            return false;
        }
        if (this.key == null) {
            return ((Tuple)obj).key == null;
        }
        return this.key.equals(((Tuple)obj).key);
    }

    @Override
    public int compareTo(Tuple<K, V> t) {
        if (this.keyComparator != null) {
            return this.keyComparator.compare(this.key, t.key);
        }
        return 0;
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public void setKeyComparator(Comparator<K> keyComparator) {
        this.keyComparator = keyComparator;
    }

    public String toString() {
        return "<" + this.key + "," + this.value + ">";
    }
}

