/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.BindOperation;
import org.ldaptive.BindRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.Credential;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.control.RequestControl;
import org.ldaptive.sasl.SaslConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindConnectionInitializer
implements ConnectionInitializer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String bindDn;
    private Credential bindCredential;
    private SaslConfig bindSaslConfig;
    private RequestControl[] bindControls;

    public BindConnectionInitializer() {
    }

    public BindConnectionInitializer(String dn, Credential credential) {
        this.setBindDn(dn);
        this.setBindCredential(credential);
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public void setBindDn(String dn) {
        this.logger.trace("setting bindDn: {}", (Object)dn);
        this.bindDn = dn;
    }

    public Credential getBindCredential() {
        return this.bindCredential;
    }

    public void setBindCredential(Credential credential) {
        this.logger.trace("setting bindCredential: <suppressed>");
        this.bindCredential = credential;
    }

    public SaslConfig getBindSaslConfig() {
        return this.bindSaslConfig;
    }

    public void setBindSaslConfig(SaslConfig config) {
        this.logger.trace("setting bindSaslConfig: {}", (Object)config);
        this.bindSaslConfig = config;
    }

    public RequestControl[] getBindControls() {
        return this.bindControls;
    }

    public void setBindControls(RequestControl ... c) {
        this.logger.trace("setting bindControls: {}", (Object)Arrays.toString(c));
        this.bindControls = c;
    }

    @Override
    public Response<Void> initialize(Connection c) throws LdapException {
        BindRequest request = new BindRequest();
        request.setDn(this.bindDn);
        request.setCredential(this.bindCredential);
        request.setSaslConfig(this.bindSaslConfig);
        request.setControls(this.bindControls);
        BindOperation op = new BindOperation(c);
        op.setOperationExceptionHandler(null);
        return op.execute(request);
    }

    public boolean isEmpty() {
        return this.bindDn == null && this.bindCredential == null && this.bindSaslConfig == null && this.bindControls == null;
    }

    public String toString() {
        return String.format("[%s@%d::bindDn=%s, bindSaslConfig=%s, bindControls=%s]", this.getClass().getName(), this.hashCode(), this.bindDn, this.bindSaslConfig, Arrays.toString(this.bindControls));
    }
}

