/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider;

import org.ldaptive.AbstractConfig;
import org.ldaptive.LdapException;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.ConnectionFactoryMetadata;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProviderConnectionFactory<T extends ProviderConfig>
implements ProviderConnectionFactory<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final T providerConfig;
    private final DefaultConnectionFactoryMetadata metadata;

    public AbstractProviderConnectionFactory(String url, T config) {
        if (url == null) {
            throw new IllegalArgumentException("LDAP URL cannot be null");
        }
        this.metadata = new DefaultConnectionFactoryMetadata(url);
        this.providerConfig = config;
        ((AbstractConfig)this.providerConfig).makeImmutable();
    }

    @Override
    public T getProviderConfig() {
        return this.providerConfig;
    }

    protected ConnectionFactoryMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public ProviderConnection create() throws LdapException {
        ConnectionException lastThrown = null;
        String[] urls = ((ProviderConfig)this.providerConfig).getConnectionStrategy().getLdapUrls(this.metadata);
        ProviderConnection conn = null;
        for (String url : urls) {
            try {
                this.logger.trace("[{}] Attempting connection to {} for strategy {}", new Object[]{this.metadata, url, ((ProviderConfig)this.providerConfig).getConnectionStrategy()});
                conn = this.createInternal(url);
                this.metadata.incrementCount();
                lastThrown = null;
                break;
            }
            catch (ConnectionException e) {
                lastThrown = e;
                this.logger.debug("Error connecting to LDAP URL: {}", (Object)url, (Object)e);
            }
        }
        if (lastThrown != null) {
            throw lastThrown;
        }
        return conn;
    }

    protected abstract ProviderConnection createInternal(String var1) throws LdapException;

    public String toString() {
        return String.format("[%s@%d::metadata=%s, providerConfig=%s]", this.getClass().getName(), this.hashCode(), this.metadata, this.providerConfig);
    }

    private class DefaultConnectionFactoryMetadata
    implements ConnectionFactoryMetadata {
        private final String ldapUrl;
        private int count;

        public DefaultConnectionFactoryMetadata(String s) {
            this.ldapUrl = s;
        }

        @Override
        public String getLdapUrl() {
            return this.ldapUrl;
        }

        @Override
        public int getConnectionCount() {
            return this.count;
        }

        private void incrementCount() {
            ++this.count;
            if (this.count < 0) {
                this.count = 0;
            }
        }

        public String toString() {
            return String.format("[ldapUrl=%s, count=%s]", this.ldapUrl, this.count);
        }
    }
}

