/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.api;

import java.io.IOException;
import javax.activation.MimeType;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.filter.AbstractGatewayFilter;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteRequest;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteResponse;
import org.apache.knox.gateway.util.MimeTypes;

public class UrlRewriteServletFilter
extends AbstractGatewayFilter {
    public static final String REQUEST_URL_RULE_PARAM = "request.url";
    public static final String REQUEST_HEADERS_FILTER_PARAM = "request.headers";
    public static final String REQUEST_COOKIES_FILTER_PARAM = "request.cookies";
    public static final String REQUEST_BODY_FILTER_PARAM = "request.body";
    public static final String RESPONSE_HEADERS_FILTER_PARAM = "response.headers";
    public static final String RESPONSE_COOKIES_FILTER_PARAM = "response.cookies";
    public static final String RESPONSE_BODY_FILTER_PARAM = "response.body";
    public static final MimeType HEADERS_MIME_TYPE = MimeTypes.create((String)"application/x-http-headers", null);
    public static final MimeType COOKIES_MIME_TYPE = MimeTypes.create((String)"application/x-http-cookies", null);

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterConfig config = this.getConfig();
        UrlRewriteRequest rewriteRequest = new UrlRewriteRequest(config, request);
        UrlRewriteResponse rewriteResponse = new UrlRewriteResponse(config, (HttpServletRequest)rewriteRequest, response);
        chain.doFilter((ServletRequest)rewriteRequest, (ServletResponse)rewriteResponse);
    }
}

