/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.util;

import com.pty4j.util.Pair;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public final class LazyValue<T> {
    private final Callable<T> myProvider;
    private final Object myLock = new Object();
    private volatile Pair<T, Throwable> myResult;

    public LazyValue(@NotNull Callable<T> provider) {
        this.myProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue() throws Exception {
        Pair<Object, Throwable> result = this.myResult;
        if (result != null) {
            return this.unpack(result);
        }
        Object object = this.myLock;
        synchronized (object) {
            result = this.myResult;
            if (result == null) {
                try {
                    T value = this.myProvider.call();
                    result = Pair.create(value, null);
                }
                catch (Throwable t) {
                    result = Pair.create(null, t);
                }
                this.myResult = result;
            }
        }
        return this.unpack(result);
    }

    private T unpack(@NotNull Pair<T, Throwable> result) throws Exception {
        if (result.second != null) {
            if (result.second instanceof Exception) {
                throw (Exception)result.second;
            }
            if (result.second instanceof Error) {
                throw (Error)result.second;
            }
            throw new RuntimeException("Rethrowing unknown Throwable", (Throwable)result.second);
        }
        return (T)result.first;
    }
}

