/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "Yarn"})
@InterfaceStability.Unstable
public interface DelegationTokenIssuer {
    public static final Logger TOKEN_LOG = LoggerFactory.getLogger(DelegationTokenIssuer.class);

    public String getCanonicalServiceName();

    public Token<?> getDelegationToken(String var1) throws IOException;

    default public DelegationTokenIssuer[] getAdditionalTokenIssuers() throws IOException {
        return null;
    }

    default public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
        if (credentials == null) {
            credentials = new Credentials();
        }
        ArrayList tokens = new ArrayList();
        DelegationTokenIssuer.collectDelegationTokens(this, renewer, credentials, tokens);
        return tokens.toArray(new Token[tokens.size()]);
    }

    @InterfaceAudience.Private
    public static void collectDelegationTokens(DelegationTokenIssuer issuer, String renewer, Credentials credentials, List<Token<?>> tokens) throws IOException {
        DelegationTokenIssuer[] ancillary;
        String serviceName = issuer.getCanonicalServiceName();
        if (TOKEN_LOG.isDebugEnabled()) {
            TOKEN_LOG.debug("Search token for service {} in credentials", (Object)serviceName);
        }
        if (serviceName != null) {
            Text service = new Text(serviceName);
            Token<TokenIdentifier> token = credentials.getToken(service);
            if (token == null) {
                if (TOKEN_LOG.isDebugEnabled()) {
                    TOKEN_LOG.debug("Token for service {} not found in credentials, try getDelegationToken.", (Object)serviceName);
                }
                if ((token = issuer.getDelegationToken(renewer)) != null) {
                    tokens.add(token);
                    credentials.addToken(service, token);
                }
            } else if (TOKEN_LOG.isDebugEnabled()) {
                TOKEN_LOG.debug("Token for service {} found in credentials,skip getDelegationToken.", (Object)serviceName);
            }
        }
        if ((ancillary = issuer.getAdditionalTokenIssuers()) != null) {
            for (DelegationTokenIssuer subIssuer : ancillary) {
                DelegationTokenIssuer.collectDelegationTokens(subIssuer, renewer, credentials, tokens);
            }
        }
    }
}

