/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ProcessUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessUtils.class);

    private ProcessUtils() {
    }

    public static Integer getPid() {
        int idx;
        String name;
        String pidStr = System.getenv("JVM_PID");
        if ((pidStr == null || pidStr.trim().isEmpty()) && (name = ManagementFactory.getRuntimeMXBean().getName()) != null && (idx = name.indexOf("@")) != -1) {
            pidStr = name.substring(0, name.indexOf("@"));
        }
        try {
            if (pidStr != null) {
                return Integer.valueOf(pidStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Process runCmdAsync(List<String> cmd) {
        try {
            LOG.info("Running command async: {}", cmd);
            return new ProcessBuilder(cmd).inheritIO().start();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

