/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.connection;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.curator.RetryLoop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalRetryLoop {
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalRetryLoop.class);
    private static final ThreadLocal<Entry> threadLocal = new ThreadLocal();

    public RetryLoop getRetryLoop(Supplier<RetryLoop> newRetryLoopSupplier) {
        Entry entry = threadLocal.get();
        if (entry == null) {
            entry = new Entry(new WrappedRetryLoop(newRetryLoopSupplier.get()));
            threadLocal.set(entry);
        }
        ++entry.counter;
        return entry.retryLoop;
    }

    public void release() {
        Entry entry = Objects.requireNonNull(threadLocal.get(), "No retry loop was set - unbalanced call to release()");
        if (--entry.counter <= 0) {
            threadLocal.remove();
        }
    }

    private static class WrappedRetryLoop
    extends RetryLoop {
        private final RetryLoop retryLoop;
        private Exception takenException;

        public WrappedRetryLoop(RetryLoop retryLoop) {
            this.retryLoop = retryLoop;
        }

        @Override
        public boolean shouldContinue() {
            return this.retryLoop.shouldContinue() && this.takenException == null;
        }

        @Override
        public void markComplete() {
            this.retryLoop.markComplete();
        }

        @Override
        public void takeException(Exception exception) throws Exception {
            if (this.takenException != null) {
                if (exception.getClass() != this.takenException.getClass()) {
                    log.error("Multiple exceptions in retry loop", (Throwable)exception);
                }
                throw this.takenException;
            }
            try {
                this.retryLoop.takeException(exception);
            }
            catch (Exception e) {
                this.takenException = e;
                throw e;
            }
        }
    }

    private static class Entry {
        private final RetryLoop retryLoop;
        private int counter;

        Entry(RetryLoop retryLoop) {
            this.retryLoop = retryLoop;
        }
    }
}

